/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.date;

import fr.amapj.service.services.gestioncontratsigne.AnnulationDateLivraisonDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;

public class PopupBarrerDateLivraison
extends WizardFormPopup {
    private AnnulationDateLivraisonDTO annulationDto;
    private GestionContratSigneService.ResBarrerDate resBarrerDate;

    public PopupBarrerDateLivraison(Long mcId) {
        this.setWidth(80);
        this.popupTitle = "Barrer une ou plusieurs dates de livraison (avec mise \u00e0 z\u00e9ro des quantit\u00e9s command\u00e9es)";
        this.annulationDto = new GestionContratSigneService().getAnnulationDateLivraisonDTO(mcId);
        this.setModel(this.annulationDto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieDate());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va vous permettre de barrer une ou plusieurs dates de livraisons, pour tous les adh\u00e9rents \u00e0 ce contrat.<br/>Les quantit\u00e9s command\u00e9es sur les dates barr\u00e9es seront alors remises \u00e0 z\u00e9ro pour les contrats d\u00e9j\u00e0 sign\u00e9s.<br/><br/>Exemple de cas d'utilisation : un producteur a pr\u00e9vu de livrer ses produits pendant 4 mois \u00e0 l'AMAP<br/>20 adh\u00e9rents ont souscrits \u00e0 ce contrat sur les 4 mois<br/>Suite \u00e0 un probl\u00e8me agricole ou autre, le producteur cesse ses livraisons au bout de 3 mois<br/>Cet outil permet alors de barrer les dates et de mettre \u00e0 z\u00e9ro les quantit\u00e9s command\u00e9es sur le dernier mois<br/>Il faut ensuite g\u00e9rer le trop pay\u00e9 des adh\u00e9rents sous la forme d'un avoir<br/><br/><br/>Autre exemple : un producteur ne peut assurer une livraison suite \u00e0 un probl\u00e8me de derni\u00e8re minute<br/>Cet outil permet alors de mettre \u00e0 z\u00e9ro les quantit\u00e9s command\u00e9es sur cette livraison et de barrer la livraison.<br/>";
        this.addHtml(str);
    }

    private void addFieldSaisieDate() {
        this.setStepTitle("les dates de la premi\u00e8re et de la derni\u00e8re livraison \u00e0 annuler");
        String str = "Toutes les dates de livraisons comprises entre ces deux dates seront annul\u00e9es (quantit\u00e9s mise \u00e0 z\u00e9ro)</br>";
        this.addHtml(str);
        this.addDateField("Date de la premi\u00e8re date \u00e0 annuler", "dateDebut", new IValidator[0]);
        this.addDateField("Date de la derni\u00e8re date \u00e0 annuler", "dateFin", new IValidator[0]);
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation avant suppression");
        this.resBarrerDate = new GestionContratSigneService().getAnnulationInfo(this.annulationDto);
        this.addHtml("Vous allez apporter les modifications suivantes sur ce contrat:");
        this.addHtml(this.resBarrerDate.msg);
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new GestionContratSigneService().performAnnulationDateLivraison(this.annulationDto, this.resBarrerDate);
    }
}

