/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.date;

import com.vaadin.ui.CheckBox;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontratsigne.suivimodification.SuiviModificationContrat;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupDeBarrerDateLivraison
extends WizardFormPopup {
    private ContratDTO contratDTO;
    private List<ContratLigDTO> datesBarrees;
    private ComplexTableBuilder<ContratLigDTO> builder;
    private List<ContratLigDTO> modeleContratDateToDebarrer;

    public PopupDeBarrerDateLivraison(Long idModeleContrat) {
        this.setWidth(80);
        this.popupTitle = "D\u00e9 barrer une ou plusieurs dates de livraison";
        this.contratDTO = new MesContratsService().loadContrat(idModeleContrat, null);
        this.datesBarrees = this.contratDTO.computeDateBarrees();
        this.modeleContratDateToDebarrer = new ArrayList<ContratLigDTO>();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales(), () -> this.checkDateBarrees());
        this.add(() -> this.addFieldSaisieDate(), () -> this.readDateToDebarrer());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va vous permettre de remettre \u00e0 l'\u00e9tat actif  une date de livraison qui est barr\u00e9e.<br/>Vous allez supprim\u00e9 le barr\u00e9 sur la date.<br/><br/>Exemple de cas d'utilisation : vous aviez barr\u00e9 une date car le producteur vous avait indiqu\u00e9 \u00eatre absent par exemple \u00e0 une date pr\u00e9cise.<br/>Finalement le producteur vous indique qu'il sera bien pr\u00e9sent.<br/><br/>Cet outil permet de supprimer le barr\u00e9 sur cette date<br/>";
        this.addHtml(str);
    }

    private String checkDateBarrees() {
        if (this.datesBarrees.size() == 0) {
            return "Il n'y a pas de dates barr\u00e9es sur ce contrat. Vous ne pouvez donc pas continuer.";
        }
        return null;
    }

    private void addFieldSaisieDate() {
        this.setStepTitle("les dates barr\u00e9es \u00e0 rendre actives");
        String str = "Veuillez indiquer les dates que vous souhaitez ne plus barrer </br>";
        this.addHtml(str);
        this.builder = new ComplexTableBuilder<ContratLigDTO>(this.datesBarrees);
        this.builder.setPageLength(7);
        this.builder.addDate("Date", false, 300, e -> e.date);
        this.builder.addCheckBox("Ne pas barrer cette date", "cb", true, 150, e -> this.modeleContratDateToDebarrer.contains(e), null);
        this.addComplexTable(this.builder);
    }

    private String readDateToDebarrer() {
        this.modeleContratDateToDebarrer.clear();
        int i = 0;
        while (i < this.datesBarrees.size()) {
            ContratLigDTO lig = this.datesBarrees.get(i);
            CheckBox cb = (CheckBox)this.builder.getComponent(i, "cb");
            if (((Boolean)cb.getValue()).booleanValue()) {
                this.modeleContratDateToDebarrer.add(lig);
            }
            ++i;
        }
        if (this.modeleContratDateToDebarrer.size() == 0) {
            return "Vous devez choisir au moins une date pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation avant modification");
        this.addHtml("Vous allez supprimer le barr\u00e9 sur " + this.modeleContratDateToDebarrer.size() + " dates de ce contrat:");
        this.addHtml(FormatUtils.puceDate(this.modeleContratDateToDebarrer, e -> e.date));
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (ContratLigDTO ligDTO : this.modeleContratDateToDebarrer) {
            this.contratDTO.enableThisLine(ligDTO.i);
        }
        new GestionContratService().updateDateBarreesModeleContrat(this.contratDTO);
        String details = "Liste des dates d\u00e9 barr\u00e9es : " + SuiviModificationContrat.listeDate(this.modeleContratDateToDebarrer, e -> e.date);
        SuiviModificationContrat.logModification("D\u00e9 barrer une ou plusieurs dates de livraison", this.contratDTO, details);
    }
}

