/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.grille;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.view.engine.popup.cascadingpopup.CascadingData;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.views.gestioncontratsignes.modifiermasse.grille.GrilleBarrerDateProduit;
import java.io.Serializable;

public class PopupBarrerProduit
extends WizardFormPopup {
    private Long idModeleContrat;
    private BarrerData barrerData;

    public PopupBarrerProduit(Long idModeleContrat) {
        this.setWidth(80);
        this.popupTitle = "Barrer des produits sur certaines dates";
        this.idModeleContrat = idModeleContrat;
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieDate(), () -> this.checkSaisieProduitBarre());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va vous permettre de barrer des produits sur certaines dates, pour tous les adh\u00e9rents \u00e0 ce contrat.<br/>Les quantit\u00e9s command\u00e9es sur les produits barr\u00e9s seront alors remises \u00e0 z\u00e9ro pour les contrats d\u00e9j\u00e0 sign\u00e9s.<br/><br/>Exemple de cas d'utilisation : un producteur a pr\u00e9vu de livrer des pommes et des poires pendant 2 mois \u00e0 l'AMAP.<br/>20 adh\u00e9rents ont souscrits \u00e0 ce contrat sur les 2 mois<br/>Suite \u00e0 un probl\u00e8me agricole ou autre, le producteur peut bien livrer les pommes sur 2 mois, mais il peut livrer les poires sur 1 mois seulement.<br/>Cet outil permet alors de barrer les poires sur le dernier mois et de mettre \u00e0 z\u00e9ro les quantit\u00e9s command\u00e9es pour les poires sur le mois barr\u00e9.<br/>Il faut ensuite g\u00e9rer le trop pay\u00e9 des adh\u00e9rents sous la forme d'un avoir.<br/><br/><br/>Cet outil permet aussi de faire l'op\u00e9ration inverse : rendre accessible un produit qui \u00e9tait barr\u00e9.<br/>";
        this.addHtml(str);
    }

    private void addFieldSaisieDate() {
        this.setStepTitle("choix des produits et des dates \u00e0 barrer");
        String str = "Cliquez sur le bouton ci dessous pour choisir les produits et dates \u00e0 barrer / ne pas barrer, puis apr\u00e8s cliquez sur Etape suivante";
        this.addHtml(str);
        Button button = new Button("Choix des dates / produits", (Button.ClickListener & Serializable)e -> this.handleChoixDateProduit());
        this.form.addComponent((Component)button);
    }

    private void handleChoixDateProduit() {
        this.barrerData = new BarrerData();
        this.barrerData.idModeleContrat = this.idModeleContrat;
        GrilleBarrerDateProduit.open(new GrilleBarrerDateProduit(this.barrerData), () -> this.endChoixDateProduit(this.barrerData));
    }

    private void endChoixDateProduit(BarrerData barrerData) {
        if (!barrerData.shouldContinue()) {
            this.close();
        }
    }

    private String checkSaisieProduitBarre() {
        if (this.barrerData == null) {
            return "Vous devez cliquer sur le bouton \"Choix des dates / produits\"";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation avant suppression");
        this.addHtml("Vous allez apporter les modifications suivantes sur ce contrat:");
        this.addHtml(this.barrerData.resBarrerProduit.msg);
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new GestionContratSigneService().performBarrerProduitInfo(this.barrerData.resBarrerProduit, this.barrerData.contratDTO);
    }

    public class BarrerData
    extends CascadingData {
        public Long idModeleContrat;
        public ContratDTO contratDTO;
        public GestionContratSigneService.ResBarrerProduit resBarrerProduit;
    }
}

