/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.paiement;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.StrategiePaiement;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mespaiements.PaiementService;
import fr.amapj.view.views.gestioncontrat.editorpart.GestionContratEditorPart;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratPaiementUtils;

public class PopupActiverSuiviPaiement
extends GestionContratEditorPart {
    private int nbInscrits;

    public PopupActiverSuiviPaiement(Long id) {
        this.setWidth(80);
        this.popupTitle = "Activer le suivi des paiements pour un contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        new GestionContratPaiementUtils().checkAndUpdateStrategieAndSaisiePaiementCalculDate(this.modeleContrat);
        this.setModel(this.modeleContrat);
        if (this.modeleContrat.gestionPaiement == GestionPaiement.GESTION_STANDARD) {
            throw new AmapjRuntimeException();
        }
        this.nbInscrits = new GestionContratService().getNbInscrits(id);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addIntro());
        this.add(() -> this.addStep2(), () -> this.checkStep2());
        this.add(() -> this.addStep3());
    }

    private void addIntro() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Le suivi des paiements n'est pas activ\u00e9 pour ce contrat pour le moment. En continuant, vous allez pouvoir activer le suivi des paiement.<br/><br/>Par contre, " + this.nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat, pour ces personnes il sera IMPERATIF de saisir manuellement les paiements.<br/>" + " Cliquer sur Continuer pour activer le suivi des paiements";
        this.addHtml(str);
    }

    private void addStep2() {
        this.modeleContrat.strategiePaiement = StrategiePaiement.UN_CHEQUE_PAR_MOIS_LISSE_MODIFIABLE_1ERE_LIVRAISON;
        this.drawTypePaiement(new StrategiePaiement[]{StrategiePaiement.NON_GERE});
    }

    private String checkStep2() {
        return this.checkTypePaiement();
    }

    private void addStep3() {
        this.drawDetailPaiement(true);
    }

    @Override
    protected void performSauvegarder() {
        new PaiementService().updateInfoPaiement(this.modeleContrat, true);
    }

    @Override
    protected String checkInitialCondition() {
        if (this.nbInscrits == 0) {
            String str = "Aucun adh\u00e9rent n'est inscrit \u00e0 ce contrat. Vous pouvez donc modifier les r\u00e8gles de paiements librement, en allant dans \"Gestion des contrats vierges\", puis vous cliquez sur le bouton \"Modifier\" puis \"les informations de paiements\"<br/>";
            return str;
        }
        return null;
    }
}

