/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.paiement;

import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.service.services.gestioncontrat.DatePaiementModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.mespaiements.PaiementService;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionNoDuplicates;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionSizeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ColumnNotNull;

public class PopupPaiementDate
extends WizardFormPopup {
    private ModeleContratDTO modeleContrat;

    public PopupPaiementDate(Long id) {
        this.setWidth(80);
        this.popupTitle = "Modification des dates de paiement d'un contrat (ajout / suppression)";
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        this.setModel(this.modeleContrat);
    }

    @Override
    protected String checkInitialCondition() {
        if (this.modeleContrat.gestionPaiement == GestionPaiement.NON_GERE) {
            String str = "Ce contrat ne g\u00e8re pas les paiements, vous ne pouvez donc pas modifier les dates de paiements.<br/>Si vous souhaitez que ce contrat g\u00e9re les paiements, vous devez aller dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\" puis \"G\u00e9rer / Ne plus g\u00e9rer les paiements\"<br/>";
            return str;
        }
        return null;
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfo());
        this.add(() -> this.addFieldDatePaiement());
    }

    private void addFieldInfo() {
        this.setStepTitle("information");
        String content = "Cet outil vous permet d'ajouter des dates de paiement ou d'en supprimer<br/>m\u00eame si il y d\u00e9j\u00e0 des contrats sign\u00e9s.<br/><br/>Par contre, une date  ne pourra pas \u00eatre supprim\u00e9e si un adh\u00e9rent a positionn\u00e9 un ch\u00e8que dessus<br/>";
        this.addHtml(content);
    }

    private void addFieldDatePaiement() {
        this.setStepTitle("la modification des dates de paiements");
        CollectionSizeValidator size = new CollectionSizeValidator(1, null);
        CollectionNoDuplicates<DatePaiementModeleContratDTO> noDuplicates = new CollectionNoDuplicates<DatePaiementModeleContratDTO>(e -> e.datePaiement);
        this.addCollectionEditorField("Liste des dates de paiement", "datePaiements", DatePaiementModeleContratDTO.class, size, noDuplicates);
        this.addColumn("datePaiement", "Date", FieldType.DATE, null, new ColumnNotNull<DatePaiementModeleContratDTO>(e -> e.datePaiement));
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new PaiementService().updateDatePaiement(this.modeleContrat);
    }
}

