/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.paiement;

import com.vaadin.ui.ComboBox;
import com.vaadin.ui.TextField;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.SaisiePaiementProposition;
import fr.amapj.model.models.contrat.modele.StrategiePaiement;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mespaiements.PaiementService;
import fr.amapj.view.engine.popup.formpopup.fieldlink.FieldLink;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.views.gestioncontrat.editorpart.GestionContratEditorPart;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratPaiementUtils;
import java.util.Arrays;

public class PopupPaiementRegleGestion
extends GestionContratEditorPart {
    private int nbInscrits;

    public PopupPaiementRegleGestion(Long id) {
        this.setWidth(80);
        this.popupTitle = "Modification des conditions de paiement d'un contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        new GestionContratPaiementUtils().checkAndUpdateStrategieAndSaisiePaiementCalculDate(this.modeleContrat);
        this.setModel(this.modeleContrat);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addIntro());
        this.add(() -> this.addPaiement(), () -> this.checkTypePaiement());
        this.add(() -> this.addDetailPaiement());
    }

    private void addIntro() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        this.nbInscrits = new GestionContratService().getNbInscrits(this.modeleContrat.id);
        String str = this.nbInscrits == 0 ? "Aucun adh\u00e9rent n'est inscrit \u00e0 ce contrat. Vous pouvez donc modifier les r\u00e8gles de paiements librement." : this.nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat.<br/>" + "La modification des r\u00e8gles de paiements vont donc impacter les contrats existants.<br/><br/>" + "Il est souhaitable de v\u00e9rifier manuellement chaque contrat.<br/>";
        this.addHtml(str);
    }

    private void addPaiement() {
        if (this.nbInscrits == 0) {
            this.drawTypePaiement(new StrategiePaiement[]{StrategiePaiement.NON_GERE});
            return;
        }
        this.modeleContrat.strategiePaiement = StrategiePaiement.PLUS_DE_CHOIX;
        this.setStepTitle("gen\u00e9ralit\u00e9s sur le paiement");
        this.addComboEnumField("Mode de gestion des paiements", "strategiePaiement", new IValidator[0]).setReadOnly(true);
        ComboBox c = this.addComboEnumField("Mode de calcul de la proposition de paiement", "saisiePaiementProposition", new NotNullValidator());
        FieldLink f1 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{SaisiePaiementProposition.PAYE_AVANCE_ARRONDI, SaisiePaiementProposition.REPARTI_ARRONDI}), c);
        TextField c2 = this.addCurrencyField("Montant minimum des ch\u00e8ques", "montantChequeMiniCalculProposition", false);
        f1.addField(c2);
        this.addComboEnumField("La proposition de paiement est elle modifiable ? ", "saisiePaiementModifiable", new NotNullValidator());
    }

    private void addDetailPaiement() {
        this.drawDetailPaiement(this.nbInscrits == 0);
    }

    @Override
    protected void performSauvegarder() {
        new PaiementService().updateInfoPaiement(this.modeleContrat, this.nbInscrits == 0);
    }

    @Override
    protected String checkInitialCondition() {
        if (this.modeleContrat.gestionPaiement == GestionPaiement.NON_GERE) {
            String str = "Vous ne pouvez pas modifier les conditions de paiement de ce contrat<br/>car ce contrat ne g\u00e9re pas les paiements.<br/><br/>.Si vous souhaitez que ce contrat g\u00e9re les paiements, vous devez aller dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\" puis \"G\u00e9rer / Ne plus g\u00e9rer les paiements\"<br/>";
            return str;
        }
        return null;
    }
}

