/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontratsignes.modifiermasse.produit;

import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.views.searcher.SDProduitHorsContrat;
import java.util.List;

public class PopupProduitAjout
extends WizardFormPopup {
    private ModeleContratDTO modeleContrat;

    public PopupProduitAjout(Long mcId) {
        this.setWidth(80);
        this.popupTitle = "Ajout de produits \u00e0 un contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(mcId);
        this.setModel(this.modeleContrat);
        this.modeleContrat.produits.clear();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldSaisieProduit());
    }

    @Override
    protected String checkInitialCondition() {
        List<Produit> prs = new GestionContratSigneService().getProduitHorsContrat(this.modeleContrat.id);
        if (prs.size() != 0) {
            return null;
        }
        return "Ce producteur ne poss\u00e9de plus de produits qui pourraient \u00eatre ajout\u00e9s \u00e0 ce contrat.<br/>Si vous voulez ajouter un produit, il faut d'abord le cr\u00e9er en allant dans le menu \"Gestion des produits\"";
    }

    private void addFieldSaisieProduit() {
        this.setStepTitle("les nouveaux produits");
        SDProduitHorsContrat searcher = new SDProduitHorsContrat(this.modeleContrat.id);
        CollectionEditor<LigneContratDTO> f1 = this.addCollectionEditorField("Produits", "produits", LigneContratDTO.class, new IValidator[0]);
        f1.addSearcherColumn("produitId", "Nom du produit", FieldType.SEARCHER, null, searcher, null);
        f1.addColumn("prix", "Prix du produit", FieldType.CURRENCY, null);
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratSigneService().performAjoutProduit(this.modeleContrat);
    }
}

