/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.importdonnees;

import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.service.services.edgenerator.excel.EGListeAdherent;
import fr.amapj.service.services.edgenerator.excel.EGListeProduitProducteur;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.template.BackOfficeLongView;
import fr.amapj.view.views.importdonnees.ProduitImporter;
import fr.amapj.view.views.importdonnees.UtilisateurImporter;

public class ImportDonneesView
extends BackOfficeLongView {
    @Override
    public String getMainStyleName() {
        return "import-donnees";
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        this.addLabelH1(this, "Outil d'import des donn\u00e9es en masse");
        this.addLabel(this, "Cet outil vous permet d'importer en masse les utilisateurs, les produits et les producteurs");
        this.addEmptyLine(this);
        Panel utilisateurPanel = new Panel("Importations des utilisateurs");
        utilisateurPanel.addStyleName("action");
        utilisateurPanel.setContent(this.getUtilisateurPanel());
        Panel produitPanel = new Panel("Importations des produits et des producteurs");
        produitPanel.addStyleName("action");
        produitPanel.setContent(this.getProduitPanel());
        this.addComponent((Component)utilisateurPanel);
        this.addEmptyLine(this);
        this.addComponent((Component)produitPanel);
    }

    private Component getUtilisateurPanel() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addEmptyLine(layout);
        this.addLabel(layout, "Pour importer les utilisateurs en masse, vous devez remplir un fichier Excel \u00e0 un certain format.");
        this.addLabel(layout, "Pour avoir un exemple du fichier \u00e0 remplir, merci de cliquer sur ce lien :");
        layout.addComponent((Component)LinkCreator.createLink(new EGListeAdherent(EGListeAdherent.Type.EXAMPLE)));
        this.addEmptyLine(layout);
        this.addLabel(layout, "Une fois que votre fichier Excel est pr\u00eat, vous pouvez le charger dans l'application. Pour cela, cliquez sur le bouton \"Charger les utilisateurs\", s\u00e9lectionnez votre fichier, cliquez sur OK. Les utilisateurs seront alors automatiquement cr\u00e9\u00e9s, sans mot de passe ");
        this.addEmptyLine(layout);
        UtilisateurImporter utilisateurImporter = new UtilisateurImporter();
        Upload upload = new Upload(null, (Upload.Receiver)utilisateurImporter);
        upload.addSucceededListener((Upload.SucceededListener)utilisateurImporter);
        upload.setImmediate(true);
        upload.setButtonCaption("Charger les utilisateurs");
        layout.addComponent((Component)upload);
        this.addEmptyLine(layout);
        return layout;
    }

    private Component getProduitPanel() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addEmptyLine(layout);
        this.addLabel(layout, "Pour importer les produits et les producteurs en masse, vous devez remplir un fichier Excel \u00e0 un certain format.");
        this.addLabel(layout, "Pour avoir un exemple du fichier \u00e0 remplir, merci de cliquer sur ce lien :");
        layout.addComponent((Component)LinkCreator.createLink(new EGListeProduitProducteur(null, EGListeProduitProducteur.Type.EXAMPLE)));
        this.addLabel(layout, "Dans un premier temps, il n'est pas n\u00e9cessaire de remplir la colonne Description, vous pourrez la remplir plus tard.");
        this.addEmptyLine(layout);
        this.addLabel(layout, "Une fois que votre fichier Excel est pr\u00eat, vous pouvez le charger dans l'application. Pour cela, cliquez sur le bouton \"Charger les produits et les producteurs\", s\u00e9lectionnez votre fichier, cliquez sur OK. Les produits et les producteurs seront alors automatiquement cr\u00e9\u00e9s.");
        ProduitImporter produitImporter = new ProduitImporter();
        Upload upload = new Upload(null, (Upload.Receiver)produitImporter);
        upload.addSucceededListener((Upload.SucceededListener)produitImporter);
        upload.setImmediate(true);
        upload.setButtonCaption("Charger les produits et les producteurs");
        this.addLabel(layout, "Informations compl\u00e9mentaires : si votre fichier Excel contient des produits d\u00e9j\u00e0 existants (m\u00eame nom et m\u00eame conditionnement), ceux ci seront ignor\u00e9s (pas de blocage). Il y aura uniquement une mise \u00e0 jour de la description pour ces produits, si elle est renseign\u00e9e dans le fichier Excel");
        this.addEmptyLine(layout);
        layout.addComponent((Component)upload);
        this.addEmptyLine(layout);
        return layout;
    }

    private Label addLabelH1(VerticalLayout layout, String str) {
        Label tf = new Label(str);
        tf.addStyleName("titre");
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addLabel(VerticalLayout layout, String str) {
        Label tf = new Label(str);
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addEmptyLine(VerticalLayout layout) {
        Label tf = new Label("<br/>", ContentMode.HTML);
        layout.addComponent((Component)tf);
        return tf;
    }
}

