/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.livraisonamapien;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.GenericUtils;
import fr.amapj.model.models.param.paramecran.PELivraisonAmapien;
import fr.amapj.service.services.meslivraisons.JourLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.MesLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.MesLivraisonsService;
import fr.amapj.service.services.meslivraisons.ProducteurLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.QteProdDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.common.gapviewer.AbstractGapViewer;
import fr.amapj.view.views.common.gapviewer.GapViewerUtil;
import fr.amapj.view.views.common.utilisateurselector.UtilisateurSelectorPart;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LivraisonAmapienView
extends FrontOfficeView
implements PopupListener {
    private static String LABEL_DATEJOURLIV = "datejourliv";
    private static String LABEL_QTEPRODUIT = "qteproduit";
    private static String PANEL_UNJOUR = "unjour";
    private VerticalLayout planning;
    private VerticalLayout livraison;
    private AbstractGapViewer semaineViewer;
    private UtilisateurSelectorPart utilisateurSelector;
    private SimpleDateFormat df1 = new SimpleDateFormat("EEEEE dd MMMMM yyyy");

    @Override
    public String getMainStyleName() {
        return "livraison-amapien";
    }

    @Override
    public void enter() {
        this.utilisateurSelector = new UtilisateurSelectorPart(this);
        this.addComponent((Component)this.utilisateurSelector.getChoixUtilisateurComponent());
        PELivraisonAmapien pe = (PELivraisonAmapien)new ParametresService().loadParamEcran(MenuList.LIVRAISON_AMAPIEN);
        this.semaineViewer = GapViewerUtil.createGapWiever(pe.modeAffichage, this, (date, next) -> this.handleNextDate(date, next));
        this.addComponent((Component)this.semaineViewer.getComponent());
        VerticalLayout central = new VerticalLayout();
        this.addComponent((Component)central);
        this.planning = new VerticalLayout();
        central.addComponent((Component)this.planning);
        this.livraison = new VerticalLayout();
        central.addComponent((Component)this.livraison);
        this.onPopupClose();
    }

    @Override
    public void onPopupClose() {
        this.planning.removeAllComponents();
        this.livraison.removeAllComponents();
        Long idUtilisateur = this.utilisateurSelector.getUtilisateurId();
        if (idUtilisateur == null) {
            return;
        }
        MesLivraisonsDTO res = new MesLivraisonsService().getMesLivraisons(this.semaineViewer.getDateDebut(), this.semaineViewer.getDateFin(), SessionManager.getUserRoles(), idUtilisateur);
        BaseUiTools.addEmptyLine((Layout)this.planning);
        for (JourLivraisonsDTO jour : res.jours) {
            VerticalLayout vl = BaseUiTools.addPanel((Layout)this.livraison, PANEL_UNJOUR);
            String dateMessage = this.df1.format(jour.date);
            BaseUiTools.addStdLabel((Layout)vl, dateMessage, LABEL_DATEJOURLIV);
            if (jour.permanences != null) {
                for (JourLivraisonsDTO.InfoPermanence info : jour.permanences) {
                    String msg = "<br/><h2><i><b>Cet amapien est de permanence ce " + this.df1.format(jour.date) + " (" + info.periodePermanenceDTO.nom + ")</br>" + "Liste des personnes de permanence : " + info.dateDTO.getNomInscrit() + "</i></b></h2>";
                    BaseUiTools.addHtmlLabel((Layout)vl, msg, "");
                }
            }
            for (ProducteurLivraisonsDTO producteurLiv : jour.producteurs) {
                BaseUiTools.addBandeau((Layout)vl, producteurLiv.modeleContrat, "nomcontrat");
                for (QteProdDTO cell : producteurLiv.produits) {
                    String content = String.valueOf(cell.qte) + " " + cell.nomProduit + " , " + cell.conditionnementProduit;
                    BaseUiTools.addStdLabel((Layout)vl, content, LABEL_QTEPRODUIT);
                }
                if (BaseUiTools.isCompactMode()) continue;
                vl.addComponent((Component)new Label("<br/>", ContentMode.HTML));
            }
        }
        this.endOfRefresh();
    }

    private GenericUtils.Ret<Date> handleNextDate(Date date, boolean next) {
        Long idUtilisateur = this.utilisateurSelector.getUtilisateurId();
        if (idUtilisateur == null) {
            return GenericUtils.Ret.error("Merci de saisir l'amapien");
        }
        Date d = new MesLivraisonsService().provideNextDate(date, next, idUtilisateur);
        if (d == null) {
            return GenericUtils.Ret.error(next ? "Il n'y a pas de date de livraison suivante" : "Il n'y a pas de date de livraison pr\u00e9cedente");
        }
        return GenericUtils.Ret.ok(d);
    }
}

