/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.login;

import com.ejt.vaadin.loginform.LoginForm;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Link;
import com.vaadin.ui.Panel;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.ui.AmapUI;
import fr.amapj.view.engine.ui.ValoMenuLayout;
import fr.amapj.view.views.login.passwordrecovery.PopupSaisieEmailForPasswordRecovery;
import java.io.Serializable;

public class LoginPart {
    private PasswordManager passwordManager = new PasswordManager();
    private AmapUI ui;
    private int nbComposant = 6;

    public void buildLoginView(ValoMenuLayout root, AmapUI ui, String loginFromUrl, String passwordFromUrl, String sudo) {
        this.ui = ui;
        CssLayout loginAera = root.prepareForLoginPage();
        VerticalLayout loginLayout = new VerticalLayout();
        loginLayout.setSizeFull();
        loginAera.setStyleName("login-backgroundimage");
        loginAera.addComponent((Component)loginLayout);
        String nomAmap = new ParametresService().getParametres().nomAmap;
        ui.getPage().setTitle(nomAmap);
        MyLoginForm myLoginForm = new MyLoginForm(loginFromUrl, passwordFromUrl, sudo, nomAmap);
        myLoginForm.addStyleName("login-layout");
        loginLayout.addComponent((Component)myLoginForm);
        loginLayout.setComponentAlignment((Component)myLoginForm, Alignment.MIDDLE_CENTER);
        loginLayout.setExpandRatio((Component)myLoginForm, 10.0f);
        Label l1 = new Label("Application fonctionnant avec AmapJ - ");
        Link link = new Link("Plus d'infos", (Resource)new ExternalResource("https://amapj.fr"));
        link.setTargetName("_blank");
        HorizontalLayout hL = new HorizontalLayout();
        hL.addComponent((Component)l1);
        hL.setComponentAlignment((Component)l1, Alignment.MIDDLE_CENTER);
        hL.addComponent((Component)link);
        hL.setComponentAlignment((Component)link, Alignment.MIDDLE_CENTER);
        hL.setMargin(true);
        loginLayout.addComponent((Component)hL);
        loginLayout.setComponentAlignment((Component)hL, Alignment.BOTTOM_CENTER);
        loginLayout.setExpandRatio((Component)hL, 1.0f);
        if (passwordFromUrl != null && loginFromUrl != null) {
            myLoginForm.login(loginFromUrl, passwordFromUrl);
        }
    }

    public class MyLoginForm
    extends LoginForm {
        String loginFromUrl;
        String passwordFromUrl;
        String sudo;
        String nomAmap;
        VerticalLayout layout;
        TextField userNameField;

        public MyLoginForm(String loginFromUrl, String passwordFromUrl, String sudo, String nomAmap) {
            this.loginFromUrl = loginFromUrl;
            this.passwordFromUrl = passwordFromUrl;
            this.sudo = sudo;
            this.nomAmap = nomAmap;
        }

        protected Component createContent(TextField userNameField, PasswordField passwordField, Button loginButton) {
            Panel p = new Panel();
            p.setWidth("100%");
            this.layout = new VerticalLayout();
            this.layout.setSpacing(true);
            this.layout.setMargin(true);
            this.layout.setSizeFull();
            p.setContent((Component)this.layout);
            Label section = new Label(this.nomAmap);
            section.addStyleName("h2");
            section.addStyleName("colored");
            section.setSizeUndefined();
            this.layout.addComponent((Component)section);
            this.layout.setComponentAlignment((Component)section, Alignment.MIDDLE_CENTER);
            this.userNameField = userNameField;
            userNameField.setCaption("Adresse Email");
            userNameField.setStyleName("name");
            userNameField.setWidth("100%");
            userNameField.setId("amapj.login.email");
            if (this.loginFromUrl != null) {
                userNameField.setValue(this.loginFromUrl);
            }
            this.layout.addComponent((Component)userNameField);
            passwordField.setCaption("Mot de passe");
            passwordField.setStyleName("password");
            passwordField.setWidth("100%");
            passwordField.setId("amapj.login.password");
            if (this.passwordFromUrl != null) {
                passwordField.setValue(this.passwordFromUrl);
            }
            this.layout.addComponent((Component)passwordField);
            if (this.loginFromUrl == null || this.loginFromUrl.length() == 0) {
                userNameField.focus();
            } else {
                passwordField.focus();
            }
            BaseUiTools.addEmptyLine((Layout)this.layout);
            if (!BaseUiTools.isCompactMode()) {
                BaseUiTools.addEmptyLine((Layout)this.layout);
                LoginPart loginPart = LoginPart.this;
                loginPart.nbComposant = loginPart.nbComposant + 1;
            }
            loginButton.setCaption("S'identifier");
            loginButton.setId("amapj.login.signin");
            if (this.sudo != null) {
                loginButton.setCaption("SUDO");
            }
            loginButton.addStyleName("primary");
            this.layout.addComponent((Component)loginButton);
            this.layout.setComponentAlignment((Component)loginButton, Alignment.MIDDLE_CENTER);
            Button lostPwd = new Button("Mot de passe perdu ?");
            lostPwd.addStyleName("link");
            lostPwd.addStyleName("perdu");
            this.layout.addComponent((Component)lostPwd);
            this.layout.setComponentAlignment((Component)lostPwd, Alignment.BOTTOM_LEFT);
            lostPwd.addClickListener((Button.ClickListener & Serializable)e -> new PopupSaisieEmailForPasswordRecovery().open());
            return p;
        }

        protected void login(String userName, String password) {
            String msg = LoginPart.this.passwordManager.checkUser(userName, password, this.sudo);
            if (msg == null) {
                LoginPart.this.ui.buildMainView();
            } else {
                msg = this.addInfo(msg, userName);
                if (this.layout.getComponentCount() > LoginPart.this.nbComposant) {
                    this.layout.removeComponent(this.layout.getComponent(LoginPart.this.nbComposant));
                }
                Label error = new Label(msg, ContentMode.HTML);
                error.setWidth("100%");
                error.addStyleName("failure");
                this.layout.addComponent((Component)error);
                this.userNameField.focus();
            }
        }

        private String addInfo(String msg, String userName) {
            if (userName.indexOf(32) != -1) {
                return "Votre e mail contient un espace. Merci de corriger.<br/>Autres d\u00e9tails : " + msg;
            }
            return msg;
        }
    }
}

