/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.logview;

import com.vaadin.data.Container;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.ui.AmapJLogManager;
import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChoixLogLevel
extends CorePopup {
    private static final Logger logger = LogManager.getLogger();
    private OptionGroup group;

    public ChoixLogLevel() {
        this.popupTitle = "Choix du niveau de logs";
        this.setWidth(50);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        boolean debug = AmapJLogManager.getLevel().intLevel() == Level.DEBUG.intLevel();
        this.group = new OptionGroup("Choix du niveau de log");
        this.group.addItem((Object)"INFO");
        this.group.addItem((Object)"DEBUG");
        if (debug) {
            this.group.select((Object)"DEBUG");
        } else {
            this.group.select((Object)"INFO");
        }
        contentLayout.addComponent((Component)this.group);
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addDefaultButton("Sauvegarder", (Button.ClickListener & Serializable)e -> this.handleContinuer());
        this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
    }

    protected void handleAnnuler() {
        this.close();
    }

    protected void handleContinuer() {
        int index = ((Container.Indexed)this.group.getContainerDataSource()).indexOfId(this.group.getValue());
        if (index == 0) {
            logger.info("Passage de logs au niveau INFO");
            AmapJLogManager.setLevel(Level.INFO);
        } else if (index == 1) {
            logger.info("Passage de logs au niveau DEBUG");
            AmapJLogManager.setLevel(Level.DEBUG);
        }
        this.close();
    }
}

