/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.logview;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.service.services.edgenerator.excel.EGStatAccess;
import fr.amapj.service.services.logview.LogViewService;
import fr.amapj.service.services.logview.StatAccessDTO;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.util.List;

public class StatAccessView
extends StandardListPart<StatAccessDTO> {
    public StatAccessView() {
        super(StatAccessDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Statistiques des acc\u00e8s";
    }

    @Override
    protected void drawButton() {
        this.addButtonAction("Rafraichir", ButtonType.ALWAYS, () -> this.refreshTable());
        this.addButton("T\u00e9l\u00e9charger", ButtonType.ALWAYS, e -> this.handleTelecharger());
        this.addButton("Authentification", ButtonType.ALWAYS, e -> this.handleInfoAuthentification());
    }

    @Override
    protected void addExtraComponent() {
        this.addComponent((Component)new Label("Authentification : " + PasswordManager.authentificationCounter.getLastInfo()));
    }

    private MessagePopup handleInfoAuthentification() {
        String msg = PasswordManager.authentificationCounter.getAllInfos();
        return new MessagePopup("Info authentification", ContentMode.HTML, CorePopup.ColorStyle.GREEN, msg);
    }

    @Override
    protected void drawTable() {
        this.addColumnDate("date", "Date");
        this.addColumn("nbAcces", "Nb d'acc\u00e8s");
        this.addColumn("nbVisiteur", "Nb de visiteurs diff\u00e9rents");
        this.addColumn("tempsTotal", "temps total en minutes");
    }

    @Override
    protected List<StatAccessDTO> getLines() {
        return new LogViewService().getStats();
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom", "prenom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom", "prenom"};
    }

    private TelechargerPopup handleTelecharger() {
        TelechargerPopup popup = new TelechargerPopup("Statistiques");
        popup.addGenerator(new EGStatAccess());
        return popup;
    }
}

