/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.mesadhesions;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.service.services.edgenerator.pdf.PGBulletinAdhesion;
import fr.amapj.service.services.mesadhesions.AdhesionDTO;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;

public class PopupAdhesionVoir
extends OKCancelPopup {
    private AdhesionDTO dto;
    private TextField textField;

    public PopupAdhesionVoir(AdhesionDTO adhesionDTO) {
        this.popupTitle = "Visualiser mon adh\u00e9sion \u00e0 l'AMAP";
        this.dto = adhesionDTO;
        this.saveButtonTitle = "OK";
        this.hasCancelButton = false;
        this.setWidth(40, 450);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        String entete = this.getEntete();
        Label l = new Label(entete, ContentMode.HTML);
        l.addStyleName("big");
        contentLayout.addComponent((Component)l);
        String bas = this.getBasPage();
        l = new Label(bas, ContentMode.HTML);
        l.addStyleName("big");
        contentLayout.addComponent((Component)l);
        this.addLinkImpressionBulletin(contentLayout);
    }

    @Override
    protected boolean performSauvegarder() {
        return true;
    }

    private String getEntete() {
        String str = "";
        str = "Vous avez renouvel\u00e9 votre adh\u00e9sion avec un montant de <b>" + new CurrencyTextFieldConverter().convertToString(this.dto.montantAdhesion) + " \u20ac</b><br/>";
        return str;
    }

    private String getBasPage() {
        String str = "";
        if (this.dto.libCheque != null) {
            str = String.valueOf(str) + "Ordre du ch\u00e8que : " + PopupAdhesionVoir.s(this.dto.libCheque) + "<br/><br/>";
        }
        if (this.dto.textPaiement != null) {
            str = String.valueOf(str) + PopupAdhesionVoir.s(this.dto.textPaiement) + "<br/>";
        }
        return str;
    }

    private void addLinkImpressionBulletin(VerticalLayout vl) {
        if (this.dto.idBulletin == null) {
            return;
        }
        vl.addComponent((Component)new Label("<br/>", ContentMode.HTML));
        Link l = LinkCreator.createLink(PGBulletinAdhesion.oneBulletinCreated(this.dto.idPeriode, this.dto.idPeriodeUtilisateur));
        l.setCaption("Imprimer mon bulletin d'adh\u00e9sion");
        l.setStyleName("adhesion");
        vl.addComponent((Component)l);
    }
}

