/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.mescontrats;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.mescontrats.small.SmallContratDTO;
import fr.amapj.service.services.mescontrats.small.inscription.InscriptionButton;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.io.Serializable;

public class InscriptionButtonModule {
    private PopupListener view;

    public InscriptionButtonModule(PopupListener view) {
        this.view = view;
    }

    public void buildBloc(HorizontalLayout hl, SmallContratDTO c) {
        VerticalLayout vl2 = new VerticalLayout();
        vl2.setWidth("115px");
        vl2.setSpacing(true);
        InscriptionButton[] inscriptionButtonArray = c.inscriptionDTO.buttons;
        int n = c.inscriptionDTO.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            InscriptionButton button = inscriptionButtonArray[n2];
            switch (button) {
                case SINCRIRE: {
                    this.addButtonSinscrire(vl2, c);
                    break;
                }
                case MODIFIER: {
                    this.addButtonModifier(vl2, c);
                    break;
                }
                case SUPPRIMER: {
                    this.addButtonSupprimer(vl2, c);
                    break;
                }
                case JOKER: {
                    this.addButtonJoker(vl2, c);
                    break;
                }
                case VOIR: {
                    this.addButtonVoir(vl2, c);
                    break;
                }
                default: {
                    throw new AmapjRuntimeException();
                }
            }
            ++n2;
        }
        hl.addComponent((Component)vl2);
        hl.setComponentAlignment((Component)vl2, Alignment.MIDDLE_CENTER);
    }

    private void addButtonSinscrire(VerticalLayout vl2, SmallContratDTO c) {
        Button b = this.addButtonInscription("S'inscrire", c);
        if (c.inscriptionDTO.isRetardataire) {
            b.addStyleName("retardataire");
        } else {
            b.addStyleName("principal");
        }
        vl2.addComponent((Component)b);
    }

    private void addButtonModifier(VerticalLayout vl2, SmallContratDTO c) {
        Button b = this.addButtonInscription("Modifier", c);
        vl2.addComponent((Component)b);
    }

    private void addButtonSupprimer(VerticalLayout vl2, SmallContratDTO c) {
        Button b = this.addButtonSupprimer("Supprimer", c);
        vl2.addComponent((Component)b);
    }

    private void addButtonJoker(VerticalLayout vl2, SmallContratDTO c) {
        Button b = this.addButtonJoker("G\u00e9rer jokers", c);
        vl2.addComponent((Component)b);
    }

    private void addButtonVoir(VerticalLayout vl2, SmallContratDTO c) {
        Button b = this.addButtonVoir("Voir", c);
        if (c.inscriptionDTO.isRetardataire) {
            b.addStyleName("retardataire");
        } else {
            b.addStyleName("principal");
        }
        vl2.addComponent((Component)b);
    }

    private Button addButtonInscription(String str, SmallContratDTO c) {
        Button b = new Button(str);
        b.setWidth("100%");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleInscription(c, SaisieContrat.ModeSaisie.STANDARD));
        return b;
    }

    private Button addButtonVoir(String str, SmallContratDTO c) {
        Button b = new Button(str);
        b.setWidth("100%");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleInscription(c, SaisieContrat.ModeSaisie.READ_ONLY));
        return b;
    }

    private Button addButtonJoker(String str, SmallContratDTO c) {
        Button b = new Button(str);
        b.setWidth("100%");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleJoker(smallContratDTO.modeleContratId, smallContratDTO.contratId));
        return b;
    }

    private void handleJoker(Long modeleContratId, Long contratId) {
        SaisieContrat.saisieContrat(modeleContratId, contratId, SessionManager.getUserId(), null, SaisieContrat.ModeSaisie.JOKER, this.view);
    }

    private Button addButtonSupprimer(String str, SmallContratDTO c) {
        Button b = new Button(str);
        b.setWidth("100%");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleSupprimer(c));
        return b;
    }

    private void handleSupprimer(SmallContratDTO c) {
        String text = "Etes vous s\u00fbr de vouloir supprimer le contrat de " + c.nom + " ?";
        SuppressionPopup confirmPopup = new SuppressionPopup(text, c.contratId, e -> new MesContratsService().deleteContrat((Long)e));
        confirmPopup.open(this.view);
    }

    private void handleInscription(SmallContratDTO c, SaisieContrat.ModeSaisie modeSaisie) {
        SaisieContrat.saisieContrat(c.modeleContratId, c.contratId, SessionManager.getUserId(), null, modeSaisie, this.view);
    }
}

