/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.mescontrats;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineDTO;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineService;
import fr.amapj.service.services.docengagement.signonline.core.CoreDocEngagementSignOnLineService;
import fr.amapj.service.services.edgenerator.pdf.PGEngagement;
import fr.amapj.service.services.mescontrats.DocEngagementDTO;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.io.Serializable;
import java.util.List;

public class PopupSignatureAmapienOneByOne
extends CorePopup {
    private CheckBox cb;
    private List<DocEngagementSignOnLineDTO> dtos;
    private int index;
    private VerticalLayout contentLayout;
    private DocEngagementSignOnLineDTO dto;
    private Button btnSave;
    private byte[] pdfContent;
    private PGEngagement generator;

    public PopupSignatureAmapienOneByOne(Long userId) {
        this.dtos = new DocEngagementSignOnLineService().getAllContratASignerByAmapien(userId);
        this.popupTitle = "Signature des documents d'engagement";
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contentLayout = contentLayout;
        this.dto = this.dtos.get(this.index);
        this.generator = new PGEngagement(PGEngagement.PGEngagementMode.UN_CONTRAT, this.dto.idModeleContrat, this.dto.idContrat, null, null, null);
        this.pdfContent = this.generator.getByteArrayContent();
        this.addLabel("");
        this.addLabel("Signature du document d'engagement " + (this.index + 1) + " / " + this.dtos.size());
        this.addLabel("");
        contentLayout.addComponent((Component)LinkCreator.createLink("contrat.pdf", "T\u00e9l\u00e9charger le document d'engagement " + this.dto.nomModeleContrat, this.pdfContent));
        this.addLabel("");
        this.cb = new CheckBox("J'ai lu et je signe ce document d'engagement");
        this.cb.setValue((Object)false);
        this.cb.addStyleName("signature");
        contentLayout.addComponent((Component)this.cb);
        this.setLibBtnSave();
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
        this.btnSave = this.addDefaultButton("", (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
        this.setLibBtnSave();
    }

    private void setLibBtnSave() {
        if (this.btnSave == null) {
            return;
        }
        this.btnSave.setCaption(this.index == this.dtos.size() - 1 ? "Terminer" : "Continuer ...");
    }

    protected void handleAnnuler() {
        this.close();
    }

    public void handleSauvegarder() {
        if (!((Boolean)this.cb.getValue()).booleanValue()) {
            new MessagePopup("Validation demand\u00e9e", ContentMode.HTML, CorePopup.ColorStyle.RED, "Vous devez signer ce document d'engagement en cliquant sur la case \u00e0 cocher \"J'ai lu et je signe ce document d'engagement\"").open();
            return;
        }
        DocEngagementDTO docEngagementDTO = new DocEngagementDTO();
        docEngagementDTO.pdfContent = this.pdfContent;
        docEngagementDTO.vars = this.generator.getUsedVars();
        new CoreDocEngagementSignOnLineService().saveDocEngagementSigneByAmapien(docEngagementDTO, this.dto.idContrat);
        if (this.index == this.dtos.size() - 1) {
            this.close();
        } else {
            this.contentLayout.removeAllComponents();
            ++this.index;
            this.createContent(this.contentLayout);
        }
    }

    private void addLabel(String str) {
        Label l = new Label(str);
        this.contentLayout.addComponent((Component)l);
    }
}

