/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.mescontrats;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.param.paramecran.PEMesContrats;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.services.docengagement.DocEngagementGeneralService;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.amapien.EGFeuilleDistributionAmapien;
import fr.amapj.service.services.mescontrats.small.SmallContratDTO;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TelechargerMesContrat {
    TelechargerPopup popup;
    PEMesContrats peMesContrats;
    List<SmallContratDTO> existingContrats;

    public void displayPopupTelechargerMesContrat(PEMesContrats peMesContrats, List<SmallContratDTO> existingContrats, PopupListener listener) {
        this.existingContrats = existingContrats;
        this.popup = new TelechargerPopup("T\u00e9l\u00e9charger les documents relatifs \u00e0 mes contrats", 80);
        this.peMesContrats = peMesContrats;
        switch (peMesContrats.presentationImpressionContrat) {
            case CONTRAT_FIRST: {
                this.displayBlocContrat();
                this.displayBlocEngagement(true);
                this.displayBlocEngagement(false);
                break;
            }
            case ENGAGEMENT_FIRST: {
                this.displayBlocEngagement(true);
                this.displayBlocEngagement(false);
                this.displayBlocContrat();
                break;
            }
            case MELANGE: {
                this.displayMelange();
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
        CorePopup.open(this.popup, listener);
    }

    private void displayBlocContrat() {
        ArrayList<CoreGenerator> gs = new ArrayList<CoreGenerator>();
        for (SmallContratDTO c : this.existingContrats) {
            if (!this.canPrintContrat(c)) continue;
            gs.add(new EGFeuilleDistributionAmapien(EGFeuilleDistributionAmapien.EGMode.STD, c.modeleContratId, c.contratId));
        }
        if (gs.size() > 0) {
            this.popup.addLabel("<b>Mes feuilles de distribution (format tableur)</b>");
            this.addAll(gs);
        }
    }

    private boolean canPrintContrat(SmallContratDTO c) {
        switch (this.peMesContrats.canPrintContrat) {
            case TOUJOURS: {
                return true;
            }
            case JAMAIS: {
                return false;
            }
            case APRES_DATE_FIN_DES_INSCRIPTIONS: {
                if (c.dateFinInscription == null) {
                    return true;
                }
                Date dateRef = DateUtils.getDateWithNoTime();
                return dateRef.after(c.dateFinInscription);
            }
        }
        throw new AmapjRuntimeException();
    }

    private void displayBlocEngagement(boolean signOnLine) {
        ArrayList<CoreGenerator> gs = new ArrayList<CoreGenerator>();
        for (SmallContratDTO c : this.existingContrats) {
            if (!this.canPrintContratEngagement(c)) continue;
            DocEngagementGeneralService.DocInfo docInfo = new DocEngagementGeneralService().getDocumentEngagementForContrat(c.contratId);
            if (signOnLine) {
                if (docInfo.gestionDocEngagement != GestionDocEngagement.SIGNATURE_EN_LIGNE || !docInfo.isSigned) continue;
                gs.add(docInfo.generator);
                continue;
            }
            if (docInfo.gestionDocEngagement != GestionDocEngagement.GENERATION_DOCUMENT_SEUL) continue;
            gs.add(docInfo.generator);
        }
        if (gs.size() > 0) {
            if (signOnLine) {
                this.popup.addLabel("<b>Mes documents d'engagement sign\u00e9s en ligne</b>");
            } else {
                this.popup.addLabel("<b>Mes documents d'engagement \u00e0 signer au format papier</b>");
            }
            this.addAll(gs);
        }
    }

    private boolean canPrintContratEngagement(SmallContratDTO c) {
        switch (this.peMesContrats.canPrintContratEngagement) {
            case TOUJOURS: {
                return true;
            }
            case JAMAIS: {
                return false;
            }
            case APRES_DATE_FIN_DES_INSCRIPTIONS: {
                if (c.dateFinInscription == null) {
                    return true;
                }
                Date dateRef = DateUtils.getDateWithNoTime();
                return dateRef.after(c.dateFinInscription);
            }
        }
        throw new AmapjRuntimeException();
    }

    private void displayMelange() {
        for (SmallContratDTO c : this.existingContrats) {
            if (this.canPrintContrat(c)) {
                this.popup.addGenerator(new EGFeuilleDistributionAmapien(EGFeuilleDistributionAmapien.EGMode.STD, c.modeleContratId, c.contratId));
            }
            if (this.canPrintContratEngagement(c)) {
                DocEngagementGeneralService.DocInfo docInfo = new DocEngagementGeneralService().getDocumentEngagementForContrat(c.contratId);
                if (docInfo.gestionDocEngagement == GestionDocEngagement.GENERATION_DOCUMENT_SEUL) {
                    this.popup.addGenerator(docInfo.generator);
                } else if (docInfo.gestionDocEngagement == GestionDocEngagement.SIGNATURE_EN_LIGNE && docInfo.isSigned) {
                    this.popup.addGenerator(docInfo.generator);
                }
            }
            this.popup.addLabel("");
        }
    }

    private void addAll(List<CoreGenerator> gs) {
        for (CoreGenerator g : gs) {
            this.popup.addGenerator(g);
        }
    }
}

