/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.meslivraisons;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.paramecran.PEMesLivraisons;
import fr.amapj.service.services.edgenerator.excel.emargement.EGFeuilleEmargement;
import fr.amapj.service.services.meslivraisons.JourLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.MesLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.MesLivraisonsService;
import fr.amapj.service.services.meslivraisons.ProducteurLivraisonsDTO;
import fr.amapj.service.services.meslivraisons.QteProdDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.common.gapviewer.AbstractGapViewer;
import fr.amapj.view.views.common.gapviewer.GapViewerUtil;
import fr.amapj.view.views.meslivraisons.TelechargerMesLivraisons;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MesLivraisonsView
extends FrontOfficeView
implements PopupListener {
    private static String LABEL_DATEJOURLIV = "datejourliv";
    private static String LABEL_QTEPRODUIT = "qteproduit";
    private static String PANEL_UNJOUR = "unjour";
    private VerticalLayout planning;
    private VerticalLayout livraison;
    private AbstractGapViewer semaineViewer;
    private SimpleDateFormat df1 = FormatUtils.getFullDate();
    private PEMesLivraisons peMesLivraisons;
    private Long userId;

    @Override
    public String getMainStyleName() {
        return "livraison";
    }

    @Override
    public void enter() {
        this.userId = SessionManager.getUserId();
        this.peMesLivraisons = (PEMesLivraisons)new ParametresService().loadParamEcran(MenuList.MES_LIVRAISONS);
        this.semaineViewer = GapViewerUtil.createGapWiever(this.peMesLivraisons.modeAffichage, this, (date, next) -> this.handleNextDate(date, next));
        this.addComponent((Component)this.semaineViewer.getComponent());
        VerticalLayout central = new VerticalLayout();
        this.addComponent((Component)central);
        this.planning = new VerticalLayout();
        central.addComponent((Component)this.planning);
        this.livraison = new VerticalLayout();
        central.addComponent((Component)this.livraison);
        Button telechargerButton = new Button("Imprimer mes livraisons ...");
        telechargerButton.setIcon((Resource)FontAwesome.PRINT);
        telechargerButton.addStyleName("borderless");
        telechargerButton.addStyleName("large");
        telechargerButton.addClickListener((Button.ClickListener & Serializable)e -> this.handleTelecharger());
        this.addComponent((Component)telechargerButton);
        this.setComponentAlignment((Component)telechargerButton, Alignment.MIDDLE_LEFT);
        this.onPopupClose();
    }

    private GenericUtils.Ret<Date> handleNextDate(Date date, boolean next) {
        Date d = new MesLivraisonsService().provideNextDate(date, next, this.userId);
        if (d == null) {
            return GenericUtils.Ret.error(next ? "Il n'y a pas de date de livraison suivante" : "Il n'y a pas de date de livraison pr\u00e9cedente");
        }
        return GenericUtils.Ret.ok(d);
    }

    private void handleTelecharger() {
        new TelechargerMesLivraisons().displayPopupTelecharger(this.semaineViewer, this.userId, this);
    }

    @Override
    public void onPopupClose() {
        MesLivraisonsDTO res = new MesLivraisonsService().getMesLivraisons(this.semaineViewer.getDateDebut(), this.semaineViewer.getDateFin(), SessionManager.getUserRoles(), this.userId);
        this.planning.removeAllComponents();
        for (EGFeuilleEmargement planningMensuel : res.planningMensuel) {
            this.planning.addComponent((Component)LinkCreator.createLink(planningMensuel));
        }
        if (res.planningMensuel.size() > 0) {
            BaseUiTools.addEmptyLine((Layout)this.planning);
        }
        this.livraison.removeAllComponents();
        for (JourLivraisonsDTO jour : res.jours) {
            VerticalLayout vl = BaseUiTools.addPanel((Layout)this.livraison, PANEL_UNJOUR);
            String dateMessage = this.df1.format(jour.date);
            BaseUiTools.addStdLabel((Layout)vl, dateMessage, LABEL_DATEJOURLIV);
            if (jour.permanences != null) {
                for (JourLivraisonsDTO.InfoPermanence info : jour.permanences) {
                    String msg = "<br/><h2><i><b>!! Attention, vous devez r\u00e9aliser la permanence ce " + this.df1.format(jour.date) + " (" + info.periodePermanenceDTO.nom + ")!!</br>" + "Liste des personnes de permanence : " + info.dateDTO.getNomInscrit() + "</i></b></h2>";
                    BaseUiTools.addHtmlLabel((Layout)vl, msg, "");
                }
            }
            for (ProducteurLivraisonsDTO producteurLiv : jour.producteurs) {
                this.addTitreContrat(vl, producteurLiv);
                for (QteProdDTO cell : producteurLiv.produits) {
                    String content = String.valueOf(cell.qte) + " " + cell.nomProduit + " , " + cell.conditionnementProduit;
                    BaseUiTools.addStdLabel((Layout)vl, content, LABEL_QTEPRODUIT);
                }
                if (BaseUiTools.isCompactMode()) continue;
                vl.addComponent((Component)new Label("<br/>", ContentMode.HTML));
            }
        }
        this.endOfRefresh();
    }

    private void addTitreContrat(VerticalLayout vl, ProducteurLivraisonsDTO producteurLiv) {
        if (this.peMesLivraisons.affichageMontantTotalContrat == ChoixOuiNon.NON) {
            BaseUiTools.addBandeau((Layout)vl, producteurLiv.modeleContrat, "nomcontrat");
        } else {
            BaseUiTools.addBandeau((Layout)vl, producteurLiv.modeleContrat, String.valueOf(new CurrencyTextFieldConverter().convertToString(producteurLiv.getMontantTotal())) + " \u20ac", "nomcontrat");
        }
    }
}

