/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.meslivraisons;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.periode.PeriodeManager;
import fr.amapj.common.periode.TypPeriode;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.paramecran.ChoixImpressionBilanLivraison;
import fr.amapj.model.models.param.paramecran.PEMesLivraisons;
import fr.amapj.service.services.edgenerator.excel.livraison.EGLivraisonAmapien;
import fr.amapj.service.services.edgenerator.pdf.PGLivraisonAmapien;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.views.common.gapviewer.AbstractGapViewer;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public class TelechargerMesLivraisons {
    private TelechargerPopup popup;
    private PEMesLivraisons pe;
    private Long idUtilisateur;

    public void displayPopupTelecharger(AbstractGapViewer gv, Long idUtilisateur, PopupListener listener) {
        LocalDateTime now;
        PeriodeManager pm;
        List<PeriodeManager.Periode> periodes;
        this.popup = new TelechargerPopup("Impression de mes livraisons", 80);
        this.idUtilisateur = idUtilisateur;
        this.pe = (PEMesLivraisons)new ParametresService().loadParamEcran(MenuList.MES_LIVRAISONS);
        if (this.pe.pageCouranteImpressionRecap == ChoixOuiNon.OUI) {
            this.addOneBloc(this.pe.pageCouranteFormat, gv.getTypPeriode(), gv.getDateDebut(), gv.getDateFin(), this.pe.pageCourantePdfEditionId);
        }
        if (this.pe.mensuelImpressionRecap == ChoixOuiNon.OUI && (periodes = (pm = new PeriodeManager(now = DateUtils.getLocalDateTime(), TypPeriode.MOIS, this.pe.mensuelNbJourAvant, this.pe.mensuelNbJourApres)).getAllPeriodes()).size() > 0) {
            this.popup.addLabel("<b>Les bilans mensuels de livraison</b>");
            for (PeriodeManager.Periode p : periodes) {
                this.addOneBloc(this.pe.mensuelFormat, p.typPeriode, DateUtils.asDate(p.startDate), DateUtils.asDate(p.endDate), this.pe.mensuelPdfEditionId);
            }
        }
        if (this.pe.trimestreImpressionRecap == ChoixOuiNon.OUI && (periodes = (pm = new PeriodeManager(now = DateUtils.getLocalDateTime(), TypPeriode.TRIMESTRE, this.pe.trimestreNbJourAvant, this.pe.trimestreNbJourApres)).getAllPeriodes()).size() > 0) {
            this.popup.addLabel("<b>Les bilans trimestriels de livraison</b>");
            for (PeriodeManager.Periode p : periodes) {
                this.addOneBloc(this.pe.trimestreFormat, p.typPeriode, DateUtils.asDate(p.startDate), DateUtils.asDate(p.endDate), this.pe.trimestrePdfEditionId);
            }
        }
        CorePopup.open(this.popup, listener);
    }

    private void addOneBloc(ChoixImpressionBilanLivraison format, TypPeriode typPeriode, Date dateDebut, Date dateFin, Long pdfEditionId) {
        switch (format) {
            case TABLEUR: {
                this.popup.addGenerator(new EGLivraisonAmapien(typPeriode, dateDebut, dateFin, this.idUtilisateur));
                break;
            }
            case PDF: {
                this.popup.addGenerator(new PGLivraisonAmapien(typPeriode, dateDebut, dateFin, this.idUtilisateur, pdfEditionId));
                break;
            }
            case TABLEUR_ET_PDF: {
                EGLivraisonAmapien eg = new EGLivraisonAmapien(typPeriode, dateDebut, dateFin, this.idUtilisateur);
                eg.setNameToDisplaySuffix(" (Format Tableur)");
                this.popup.addGenerator(eg);
                PGLivraisonAmapien pg = new PGLivraisonAmapien(typPeriode, dateDebut, dateFin, this.idUtilisateur, pdfEditionId);
                pg.setNameToDisplaySuffix(" (Format PDF)");
                this.popup.addGenerator(pg);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }
}

