/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.mespaiements;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.service.services.mespaiements.DetailPaiementAFournirDTO;
import fr.amapj.service.services.mespaiements.DetailPaiementFourniDTO;
import fr.amapj.service.services.mespaiements.MesPaiementsDTO;
import fr.amapj.service.services.mespaiements.MesPaiementsService;
import fr.amapj.service.services.mespaiements.PaiementAFournirDTO;
import fr.amapj.service.services.mespaiements.PaiementFourniDTO;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.SimpleDateFormat;
import java.util.List;

public class MesPaiementsView
extends FrontOfficeView {
    private static String LABEL_TEXTEFOND = "textefond";
    private static String LABEL_CONTRAT = "contrat";
    private static String LABEL_CHEQUEAFOURNIR = "chequeafournir";
    private static String LABEL_MOIS = "mois";
    private static String LABEL_CHEQUE = "cheque";
    private static String PANEL_CONTRAT = "contrat";
    private static String PANEL_CHEQUEAFOURNIR = "chequeafournir";
    private static String PANEL_AVENIR = "avenir";
    private static String PANEL_MOIS = "mois";
    private SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
    private SimpleDateFormat df2 = new SimpleDateFormat("dd MMMMM");

    @Override
    public String getMainStyleName() {
        return "paiement";
    }

    private Label addLabel(String str) {
        Label tf = new Label(str);
        tf.addStyleName(LABEL_TEXTEFOND);
        this.addComponent((Component)tf);
        return tf;
    }

    @Override
    public void enter() {
        MesPaiementsDTO mesPaiementsDTO = new MesPaiementsService().getMesPaiements(SessionManager.getUserId());
        this.addLabel("Les ch\u00e8ques que je dois donner \u00e0 l'AMAP");
        Panel p0 = new Panel();
        p0.setWidth("100%");
        p0.addStyleName(PANEL_CHEQUEAFOURNIR);
        VerticalLayout vl1 = new VerticalLayout();
        vl1.setMargin(true);
        p0.setContent((Component)vl1);
        this.addComponent((Component)p0);
        List<PaiementAFournirDTO> paiementAFournirs = mesPaiementsDTO.paiementAFournir;
        if (paiementAFournirs.size() == 0) {
            String str = "Vous \u00eates \u00e0 jour de vos paiements, vous n'avez pas de ch\u00e8ques \u00e0 fournir \u00e0 l'AMAP <br/>";
            Label l = new Label(str, ContentMode.HTML);
            l.addStyleName(LABEL_CHEQUEAFOURNIR);
            vl1.addComponent((Component)l);
        }
        for (PaiementAFournirDTO paiementAFournir : paiementAFournirs) {
            String str = this.formatContrat(paiementAFournir);
            Label l = new Label(str, ContentMode.HTML);
            l.addStyleName(LABEL_CONTRAT);
            Panel p1 = new Panel();
            p1.setContent((Component)l);
            p1.addStyleName(PANEL_CONTRAT);
            vl1.addComponent((Component)p1);
            for (DetailPaiementAFournirDTO detail : paiementAFournir.paiements) {
                str = detail.formatPaiement();
                Label ld = new Label(str, ContentMode.HTML);
                ld.addStyleName(LABEL_CHEQUEAFOURNIR);
                vl1.addComponent((Component)ld);
            }
            vl1.addComponent((Component)new Label("<br/>", ContentMode.HTML));
        }
        this.addLabel("Le planning de mes paiements \u00e0 venir mois par mois");
        Panel p = new Panel();
        p.setWidth("100%");
        p.addStyleName(PANEL_AVENIR);
        VerticalLayout vl = new VerticalLayout();
        vl.setMargin(true);
        p.setContent((Component)vl);
        this.addComponent((Component)p);
        for (PaiementFourniDTO paiementFourni : mesPaiementsDTO.paiementFourni) {
            String str = this.formatMois(paiementFourni);
            Label l = new Label(str, ContentMode.HTML);
            l.addStyleName(LABEL_MOIS);
            Panel p1 = new Panel();
            p1.setContent((Component)l);
            p1.addStyleName(PANEL_MOIS);
            vl.addComponent((Component)p1);
            for (DetailPaiementFourniDTO detail : paiementFourni.paiements) {
                str = this.formatPaiement(detail);
                Label cheque = new Label(str, ContentMode.HTML);
                cheque.addStyleName(LABEL_CHEQUE);
                vl.addComponent((Component)cheque);
            }
            vl.addComponent((Component)new Label("<br/>", ContentMode.HTML));
        }
    }

    private String formatContrat(PaiementAFournirDTO paiementAFournir) {
        String str = "Nom du contrat : " + paiementAFournir.nomContrat + "<br/>" + " Date limite de remise des ch\u00e8ques: " + this.df.format(paiementAFournir.dateRemise) + "<br/>" + " Ordre des ch\u00e8ques : " + paiementAFournir.libCheque;
        return str;
    }

    private String formatMois(PaiementFourniDTO paiementFourni) {
        String montant = String.valueOf(new CurrencyTextFieldConverter().convertToString(paiementFourni.totalMois)) + " \u20ac";
        String str = String.valueOf(paiementFourni.moisPaiement) + " - Total du mois : " + montant;
        return str;
    }

    private String formatPaiement(DetailPaiementFourniDTO detail) {
        String montant = String.valueOf(new CurrencyTextFieldConverter().convertToString(detail.montant)) + " \u20ac";
        String str = String.valueOf(this.df2.format(detail.datePaiement)) + " - Montant : " + montant + " - Contrat :" + detail.nomContrat + " - Ordre du ch\u00e8que :" + detail.libCheque;
        if (detail.etatPaiement == EtatPaiement.A_FOURNIR) {
            str = String.valueOf(str) + " (Ch\u00e8que \u00e0 fournir \u00e0 l'AMAP)";
        }
        return str;
    }
}

