/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.parametres;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.template.BackOfficeLongView;
import fr.amapj.view.views.parametres.PopupModulesOptionnels;
import fr.amapj.view.views.parametres.PopupSaisieParametres;
import fr.amapj.view.views.parametres.paramecran.PEContratsAmapienEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEGestionContratsSignesEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEGestionContratsViergesEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEListeAdherentEditorPart;
import fr.amapj.view.views.parametres.paramecran.PELivraisonAmapienEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEMesAdhesionsEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEMesContratsEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEMesLivraisonsEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEProducteurReferentEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEReceptionChequeEditorPart;
import fr.amapj.view.views.parametres.paramecran.PERemiseProducteurEditorPart;
import fr.amapj.view.views.parametres.paramecran.PESyntheseMultiContratEditorPart;
import fr.amapj.view.views.parametres.paramecran.PEVisiteAmapEditorPart;
import fr.amapj.view.views.parametres.paramecran.producteur.PEContratProducteurEditorPart;
import fr.amapj.view.views.parametres.paramecran.producteur.PELivraisonProducteurEditorPart;
import java.io.Serializable;
import java.util.function.Supplier;

public class ParametresView
extends BackOfficeLongView {
    ParametresDTO dto;
    TextField nomAmap;
    TextField villeAmap;

    @Override
    public String getMainStyleName() {
        return "parametres";
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        FormLayout form1 = new FormLayout();
        form1.setMargin(false);
        form1.addStyleName("light");
        this.addComponent((Component)form1);
        Label section = new Label("Param\u00e8tres de l'AMAP");
        section.addStyleName("h2");
        section.addStyleName("colored");
        form1.addComponent((Component)section);
        this.nomAmap = this.addTextField("Nom de l'AMAP ", form1);
        this.villeAmap = this.addTextField("Ville de l'AMAP ", form1);
        this.addButton("Changer les param\u00e8tres g\u00e9n\u00e9raux", () -> new PopupSaisieParametres(this.dto));
        this.addButton("Activer / Desactiver les modules optionnels", () -> new PopupModulesOptionnels(this.dto));
        this.addLabel("Amapien");
        this.addButton("Ecran \"Mes contrats\"", () -> new PEMesContratsEditorPart());
        this.addButton("Ecran \"Mes livraisons\"", () -> new PEMesLivraisonsEditorPart());
        this.addButton("Ecran \"Mes adh\u00e9sions\"", () -> new PEMesAdhesionsEditorPart());
        this.addButton("Ecran \"D\u00e9couverte / Visite\"", () -> new PEVisiteAmapEditorPart());
        this.addButton("Ecran \"Producteurs / R\u00e9f\u00e9rents\"", () -> new PEProducteurReferentEditorPart());
        this.addButton("Ecran \"Liste des adh\u00e9rents\"", () -> new PEListeAdherentEditorPart());
        this.addLabel("Producteur");
        this.addButton("Ecran \"Livraison d'un producteur\"", () -> new PELivraisonProducteurEditorPart());
        this.addButton("Ecran \"Contrats d'un producteur\"", () -> new PEContratProducteurEditorPart());
        this.addLabel("R\u00e9f\u00e9rent");
        this.addButton("Ecran \"Gestion des contrats vierges\"", () -> new PEGestionContratsViergesEditorPart());
        this.addButton("Ecran \"Gestion des contrats sign\u00e9s\"", () -> new PEGestionContratsSignesEditorPart());
        this.addButton("Ecran \"R\u00e9ception des ch\u00e8ques\"", () -> new PEReceptionChequeEditorPart());
        this.addButton("Ecran \"Remise aux producteurs\"", () -> new PERemiseProducteurEditorPart());
        this.addButton("Ecran \"Contrats d'un amapien\"", () -> new PEContratsAmapienEditorPart());
        this.addButton("Ecran \"Livraison d'un amapien\"", () -> new PELivraisonAmapienEditorPart());
        this.addButton("Ecran \"Synth\u00e8se multi contrats\"", () -> new PESyntheseMultiContratEditorPart());
        this.addLabel("Autres");
        this.refresh();
    }

    private void refresh() {
        this.dto = new ParametresService().getParametres();
        this.setValue(this.nomAmap, this.dto.nomAmap);
        this.setValue(this.villeAmap, this.dto.villeAmap);
    }

    private void addButton(String str, Supplier<CorePopup> popupSupplier) {
        Button newButton = new Button(str);
        newButton.addClickListener((Button.ClickListener & Serializable)e -> ((CorePopup)popupSupplier.get()).open(() -> this.refresh()));
        this.addComponent((Component)newButton);
    }

    private void setValue(TextField tf, String val) {
        tf.setReadOnly(false);
        tf.setValue(val);
        tf.setReadOnly(true);
    }

    private TextField addTextField(String lib, FormLayout form) {
        TextField name = new TextField(lib);
        name.setWidth("100%");
        name.setNullRepresentation("");
        name.setReadOnly(true);
        form.addComponent((Component)name);
        return name;
    }

    private Label addLabel(String str) {
        Label tf = new Label(str, ContentMode.HTML);
        this.addComponent((Component)tf);
        return tf;
    }

    private void addButtonNavigate(String str, Class viewClass) {
        Button newButton = new Button(str);
        newButton.addClickListener((Button.ClickListener & Serializable)e -> this.handleButtonNavigate(viewClass));
        this.addComponent((Component)newButton);
    }

    private void handleButtonNavigate(Class viewClass) {
        Navigator nav = UI.getCurrent().getNavigator();
        String name = "/" + Math.abs(viewClass.getName().hashCode());
        nav.addView(name, viewClass);
        nav.navigateTo(name);
    }
}

