/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.parametres;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.RichTextArea;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.EmailValidator;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.ui.AppConfiguration;

public class PopupSaisieParametres
extends WizardFormPopup {
    private ParametresDTO dto;
    private boolean adminFull;

    public PopupSaisieParametres(ParametresDTO dto) {
        this.setWidth(95);
        this.popupTitle = "Modification des param\u00e8tres";
        this.dto = dto;
        this.setModel(dto);
        this.adminFull = SessionManager.getSessionParameters().isAdminFull();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldAmapInfo());
        this.add(() -> this.addFieldMailInfo());
    }

    private void addFieldAmapInfo() {
        this.setStepTitle("identification de l'AMAP");
        this.addTextField("Nom de l'AMAP", "nomAmap", new IValidator[0]);
        this.addTextField("Ville de l'AMAP", "villeAmap", new IValidator[0]);
    }

    private void addFieldMailInfo() {
        this.setStepTitle("information sur l'envoi des mails");
        AppConfiguration.MailConfig mailTarget = AppConfiguration.getConf().getMailConfig();
        if (mailTarget == AppConfiguration.MailConfig.NO_MAIL) {
            this.addHtml("L'envoi des mails est desactiv\u00e9.");
            return;
        }
        if (mailTarget == AppConfiguration.MailConfig.GMAIL) {
            this.addTextField("Adresse mail qui enverra les messages", "sendingMailUsername", new IValidator[0]);
            this.addPasswordTextField("Password de l'adresse mail qui enverra les messages", "sendingMailPassword");
        } else {
            this.addTextField("Adresse mail qui enverra les messages", "sendingMailUsername", new IValidator[0]).setEnabled(this.adminFull);
        }
        this.addIntegerField("Nombre maximum de mail par jour", "sendingMailNbMax", new IValidator[0]).setEnabled(this.adminFull);
        this.addTextField("URL de l'application utilis\u00e9e dans les mails", "url", new IValidator[0]).setEnabled(this.adminFull);
        this.addTextField("Adresse mail qui sera en copie de tous les mails envoy\u00e9s par le logiciel", "mailCopyTo", new IValidator[0]);
        this.addTextField("Adresse mail du destinataire des sauvegardes quotidiennes", "backupReceiver", new EmailValidator(false));
        RichTextArea f = this.addRichTextAeraField("Texte ajout\u00e9 en bas des mails envoy\u00e9s", "sendingMailFooter");
        f.setHeight(4.0f, Sizeable.Unit.CM);
    }

    @Override
    protected void performSauvegarder() {
        new ParametresService().update(this.dto);
    }
}

