/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.detailperiode;

import com.vaadin.ui.Component;
import fr.amapj.service.services.edgenerator.excel.permanence.EGBilanInscriptionPermanence;
import fr.amapj.service.services.edgenerator.excel.permanence.EGPlanningPermanence;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.permanence.PeriodePermanenceSelectorPart;
import fr.amapj.view.views.permanence.detailperiode.PopupCalculAutoPermanence;
import fr.amapj.view.views.permanence.detailperiode.PopupDeleteInscriptionPermanence;
import fr.amapj.view.views.permanence.detailperiode.PopupModifPermanence;
import fr.amapj.view.views.permanence.detailperiode.grille.ModifierInscriptionGrillePart;
import fr.amapj.view.views.permanence.detailperiode.mail.PopupEnvoiMailPlanningPermanence;
import fr.amapj.view.views.permanence.periode.grille.VisualiserPeriodePermanenceGrillePart;
import java.util.List;

public class DetailPeriodePermanenceListPart
extends StandardListPart<PeriodePermanenceDateDTO> {
    private PeriodePermanenceSelectorPart periodeSelector = new PeriodePermanenceSelectorPart(this);

    public DetailPeriodePermanenceListPart() {
        super(PeriodePermanenceDateDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Gestion des inscriptions sur une p\u00e9riode de permanence";
    }

    @Override
    protected void addSelectorComponent() {
        this.addComponent((Component)this.periodeSelector.getChoixPeriodeComponent());
    }

    @Override
    protected void drawButton() {
        this.addButton("Visualiser grille", ButtonType.ALWAYS, e -> new VisualiserPeriodePermanenceGrillePart(this.periodeSelector.getPeriodePermanenceId(), null));
        this.addButton("Modifier grille", ButtonType.ALWAYS, e -> new ModifierInscriptionGrillePart(this.periodeSelector.getPeriodePermanenceId()));
        this.addButton("Modifier cette date", ButtonType.EDIT_MODE, e -> new PopupModifPermanence(e.idPeriodePermanenceDate));
        this.addButton("Autre ...", ButtonType.ALWAYS, e -> this.handleAutre());
        this.addButton("T\u00e9l\u00e9charger", ButtonType.ALWAYS, e -> this.handleTelecharger());
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumnDate("datePerm", "Date permanence ").width(160);
        this.addColumn("nbPlace", "Nb souhait\u00e9").width(120);
        this.addColumn("nbInscrit", "Nb inscrits").width(120);
        this.addColumn("complet", "Complet").width(80);
        this.addColumn("nomInscrit", "Noms des inscrits");
    }

    @Override
    protected List<PeriodePermanenceDateDTO> getLines() {
        Long idPeriodePermanence = this.periodeSelector.getPeriodePermanenceId();
        if (idPeriodePermanence == null) {
            return null;
        }
        return new PeriodePermanenceService().loadPeriodePermanenceDTO((Long)idPeriodePermanence).datePerms;
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"datePerm"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"datePerm", "nomInscrit"};
    }

    private CorePopup handleAutre() {
        Long idPeriodePermanence = this.periodeSelector.getPeriodePermanenceId();
        SwitchPopup popup = new SwitchPopup("Autres actions sur les permanences", 50);
        popup.addLine("Effacer les inscriptions sur une liste de date", () -> new PopupDeleteInscriptionPermanence(idPeriodePermanence));
        popup.addLine("Calculer automatiquement les inscriptions", () -> new PopupCalculAutoPermanence(idPeriodePermanence));
        popup.addLine("Envoyer un mail \u00e0 tous les participants avec le planning joint", () -> new PopupEnvoiMailPlanningPermanence(idPeriodePermanence));
        return popup;
    }

    private TelechargerPopup handleTelecharger() {
        Long idPeriodePermanence = this.periodeSelector.getPeriodePermanenceId();
        TelechargerPopup popup = new TelechargerPopup("P\u00e9riode de permanence", 80);
        popup.addGenerator(new EGPlanningPermanence(idPeriodePermanence, null));
        popup.addGenerator(new EGBilanInscriptionPermanence(idPeriodePermanence));
        return popup;
    }
}

