/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.detailperiode;

import fr.amapj.service.services.permanence.detailperiode.DetailPeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;

public class PopupDeleteInscriptionPermanence
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;

    public PopupDeleteInscriptionPermanence(Long idPeriodePermanence) {
        this.setWidth(80);
        this.popupTitle = "Suppression en masse des inscriptions \u00e0 une p\u00e9riode de permanence";
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(idPeriodePermanence);
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addAide());
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldConfirmer());
    }

    private void addAide() {
        this.setStepTitle("pr\u00e9sentation");
        String str = "Cet outil va vous permettre de supprimer une liste d'inscriptions \u00e0 des permanences en une seule fois.</br><br/>Vous allez pouvoir saisir une date de d\u00e9but, une date de fin,<br/>et toutes les inscriptions sur cet intervalle seront supprim\u00e9es.<br/>";
        this.addHtml(str);
    }

    private void addFieldInfoGenerales() {
        NotNullValidator notNull = new NotNullValidator();
        this.setStepTitle("l'intervalle de dates \u00e0 supprimer");
        this.addDateField("Date de d\u00e9but", "dateDebut", notNull);
        this.addDateField("Date de fin", "dateFin", notNull);
    }

    private void addFieldConfirmer() {
        String info = new DetailPeriodePermanenceService().getDeleteInscriptionInfo(this.dto);
        this.setStepTitle("confirmation avant suppression");
        this.addHtml("Vous allez apporter les modifications suivantes sur cette p\u00e9riode de permanence:");
        this.addHtml(info);
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() {
        new DetailPeriodePermanenceService().performDeleteInscription(this.dto);
    }
}

