/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.detailperiode.mail;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.RichTextArea;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.permanence.periode.mail.PeriodePermanenceEnvoiMailService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.genericmodel.StringItem;

public class PopupEnvoiMailPlanningPermanence
extends WizardFormPopup {
    private Long idPeriodePermanence;
    private StringItem dto;

    public PopupEnvoiMailPlanningPermanence(Long idPeriodePermanence) {
        this.setWidth(80);
        this.popupTitle = "Envoi d'un mail avec le planning des permanences";
        this.idPeriodePermanence = idPeriodePermanence;
        this.dto = new StringItem();
        this.dto.value = this.getInitialText();
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldTexteMail());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("l'envoi d'un mail avec le planning  des permanences");
        this.addHtml("Avec cet outil,  vous allez pouvoir envoyer un mail avec le planning pour toutes les personnes ayant des permanences dans le futur");
    }

    private void addFieldTexteMail() {
        this.setStepTitle("le texte du mail");
        RichTextArea f = this.addRichTextAeraField("Texte du mail", "value");
        f.setHeight(10.0f, Sizeable.Unit.CM);
    }

    @Override
    protected void performSauvegarder() {
        new PeriodePermanenceEnvoiMailService().sendMailAvecPlanning(this.dto.value, this.idPeriodePermanence);
    }

    private String getInitialText() {
        String lineSep = "<br/>";
        ParametresDTO param = new ParametresService().getParametres();
        StringBuffer buf = new StringBuffer();
        buf.append("<h2>" + param.nomAmap + "</h2>");
        buf.append("Bonjour , ");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("vous trouverez ci joint le planning de distribution pour l'ann\u00e9e \u00e0 venir.");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("En ce qui vous concerne, vos dates de permanences sont :");
        buf.append(lineSep);
        buf.append("#DATES#");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("Nous comptons sur votre participation active !!!");
        buf.append(lineSep);
        buf.append("Si vous n'\u00eates pas disponible \u00e0 une date, merci d'\u00e9changer avec un autre AMAPIEN");
        buf.append(lineSep);
        buf.append("Pour cela, prenez contact avec un autre amapien, une fois que vous avez son accord, merci de corriger le planning affich\u00e9 \u00e0 l'AMAP (en barrant au stylo)");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("Notez que vous pouvez d\u00e9sormais consulter le planning des permanences sur l'application WEB de l'AMAP");
        buf.append(lineSep);
        buf.append("#LINK#");
        buf.append(lineSep);
        buf.append(lineSep);
        buf.append("Bonne journ\u00e9e \u00e0 tous !!");
        buf.append(lineSep);
        return buf.toString();
    }
}

