/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.grille;

import com.vaadin.ui.Button;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.DebugUtil;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.permanence.grille.BlocGrille;
import fr.amapj.view.views.permanence.grille.BlocGrilleDrawer;
import java.io.Serializable;
import java.text.SimpleDateFormat;

public abstract class AbstractPeriodePermanenceGrillePart
extends CorePopup
implements PopupListener {
    protected PeriodePermanenceDTO dto;
    protected Long userId;
    private VerticalLayout contentLayout;
    private int nbCol;

    protected abstract Layout addSpecificButton(PeriodePermanenceDateDTO var1);

    protected abstract String getHeader();

    public AbstractPeriodePermanenceGrillePart(Long idPeriodePermanence, Long userId) {
        this.userId = userId;
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(idPeriodePermanence);
        this.popupTitle = "P\u00e9riode de permanence " + this.dto.nom;
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contentLayout = contentLayout;
        int widthRatio = BaseUiTools.isWidthBelow(1600) ? 100 : 80;
        String height = BaseUiTools.isWidthBelow(1600) ? "100%" : "90%";
        this.nbCol = this.computeNbCol(widthRatio);
        this.setHeight(height);
        this.setWidth(widthRatio);
        contentLayout.addStyleName("grille-permanence");
        this.drawContent();
    }

    private int computeNbCol(int widthRatio) {
        int reelWidth = BaseUiTools.computePopupWidth(widthRatio);
        DebugUtil.trace("reelWidth=" + reelWidth);
        if (reelWidth < 860) {
            return 1;
        }
        if (reelWidth < 1290) {
            return 2;
        }
        return 3;
    }

    private void drawContent() {
        this.contentLayout.removeAllComponents();
        String lib = this.getHeader();
        if (lib != null) {
            BaseUiTools.addHtmlLabel((Layout)this.contentLayout, lib, "compteur");
        }
        BlocGrilleDrawer drawer = new BlocGrilleDrawer();
        for (PeriodePermanenceDateDTO date : this.dto.datePerms) {
            drawer.addBloc(this.createBloc(date));
        }
        drawer.createContent(this.contentLayout, this.nbCol, this);
    }

    @Override
    public void onPopupClose() {
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(this.dto.id);
        this.drawContent();
    }

    private BlocGrille createBloc(PeriodePermanenceDateDTO date) {
        BlocGrille bloc = new BlocGrille();
        bloc.date = date;
        SimpleDateFormat df = FormatUtils.getFullDate();
        bloc.titre = df.format(date.datePerm);
        bloc.styleTitre = date.isDateComplete() ? "date-complete" : "date-avec-dispo";
        for (PermanenceCellDTO pc : date.permanenceCellDTOs) {
            BlocGrille.BlocGrilleLine line = new BlocGrille.BlocGrilleLine();
            line.col1 = pc.lib;
            line.styleCol1 = "role";
            if (pc.idUtilisateur == this.userId && this.userId != null) {
                line.col2 = String.valueOf(pc.nom) + " " + pc.prenom;
                line.styleCol2 = "place-moi";
            } else if (pc.idUtilisateur != null) {
                line.col2 = String.valueOf(pc.nom) + " " + pc.prenom;
                line.styleCol2 = "place-occupee";
            } else {
                line.col2 = "Place libre";
                line.styleCol2 = "place-libre";
            }
            bloc.lines.add(line);
        }
        return bloc;
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("OK", (Button.ClickListener & Serializable)e -> this.handleOK());
    }

    protected void handleOK() {
        this.close();
    }
}

