/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.grille;

import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.CollectionUtils;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.views.permanence.grille.AbstractPeriodePermanenceGrillePart;
import fr.amapj.view.views.permanence.grille.BlocGrille;
import java.util.ArrayList;
import java.util.List;

public class BlocGrilleDrawer {
    List<BlocGrille> blocGrilles = new ArrayList<BlocGrille>();

    public void addBloc(BlocGrille bloc) {
        this.blocGrilles.add(bloc);
    }

    protected void createContent(VerticalLayout contentLayout, int nbCol, AbstractPeriodePermanenceGrillePart grillePart) {
        List<List<BlocGrille>> lines = CollectionUtils.cutInSubList(this.blocGrilles, nbCol);
        for (List<BlocGrille> line : lines) {
            this.drawLine(contentLayout, line, grillePart);
            VerticalLayout spacer = new VerticalLayout();
            spacer.setHeight("10px");
            contentLayout.addComponent((Component)spacer);
        }
    }

    private void drawLine(VerticalLayout contentLayout, List<BlocGrille> line, AbstractPeriodePermanenceGrillePart grillePart) {
        HorizontalLayout hl = new HorizontalLayout();
        SizeInfo sizeInfo = this.computeSizeInfos(line);
        int i = 0;
        while (i < line.size() - 1) {
            VerticalLayout vl = new VerticalLayout();
            this.draw(vl, line.get(i), sizeInfo, grillePart);
            hl.addComponent((Component)vl);
            VerticalLayout spacer = new VerticalLayout();
            spacer.setWidth("10px");
            hl.addComponent((Component)spacer);
            ++i;
        }
        VerticalLayout vl = new VerticalLayout();
        this.draw(vl, line.get(line.size() - 1), sizeInfo, grillePart);
        hl.addComponent((Component)vl);
        contentLayout.addComponent((Component)hl);
    }

    private void draw(VerticalLayout contentLayout, BlocGrille bloc, SizeInfo sizeInfo, AbstractPeriodePermanenceGrillePart grillePart) {
        Layout layout;
        HorizontalLayout header1 = new HorizontalLayout();
        Label l = new Label(bloc.titre);
        l.addStyleName(bloc.styleTitre);
        l.setWidth("400px");
        header1.addComponent((Component)l);
        contentLayout.addComponent((Component)header1);
        int i = 0;
        while (i < bloc.lines.size()) {
            BlocGrille.BlocGrilleLine pc = bloc.lines.get(i);
            header1 = new HorizontalLayout();
            header1.setHeight(String.valueOf(sizeInfo.heights[i]) + "px");
            Label l1 = new Label(pc.col1);
            l1.setSizeFull();
            l1.addStyleName(pc.styleCol1);
            l1.setWidth("200px");
            header1.addComponent((Component)l1);
            Label l2 = new Label(pc.col2);
            l2.setSizeFull();
            l2.addStyleName(pc.styleCol2);
            l2.setWidth("200px");
            header1.addComponent((Component)l2);
            contentLayout.addComponent((Component)header1);
            ++i;
        }
        int h = this.computeHeightAdditionalSpace(sizeInfo, bloc.lines.size());
        if (h != 0) {
            header1 = new HorizontalLayout();
            header1.setHeight(String.valueOf(h) + "px");
            contentLayout.addComponent((Component)header1);
        }
        if ((layout = grillePart.addSpecificButton(bloc.date)) != null) {
            contentLayout.addComponent((Component)layout);
        }
    }

    private int computeHeightAdditionalSpace(SizeInfo sizeInfo, int start) {
        int height = 0;
        int i = start;
        while (i < sizeInfo.heights.length) {
            height += sizeInfo.heights[i];
            ++i;
        }
        return height;
    }

    private SizeInfo computeSizeInfos(List<BlocGrille> line) {
        int max = 0;
        for (BlocGrille blocGrille : line) {
            max = Math.max(max, blocGrille.lines.size());
        }
        SizeInfo sizeInfo = new SizeInfo();
        sizeInfo.heights = new int[max];
        int i = 0;
        while (i < max) {
            sizeInfo.heights[i] = this.computeHeight(i, line);
            ++i;
        }
        return sizeInfo;
    }

    private int computeHeight(int i, List<BlocGrille> line) {
        GridHeaderLine gridHeaderLine = new GridHeaderLine();
        for (BlocGrille blocGrille : line) {
            if (i >= blocGrille.lines.size()) continue;
            gridHeaderLine.addCell(blocGrille.lines.get((int)i).col1);
            gridHeaderLine.addCell(blocGrille.lines.get((int)i).col2);
        }
        GridSizeCalculator.autoSize(gridHeaderLine, 200, "Arial", 16);
        return gridHeaderLine.height;
    }

    public class SizeInfo {
        int[] heights;
    }
}

