/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.mespermanences.grille;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.permanence.periode.RegleInscriptionPeriodePermanence;
import fr.amapj.service.services.permanence.mespermanences.MesPermanencesService;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.view.views.permanence.grille.AbstractPeriodePermanenceGrillePart;
import fr.amapj.view.views.permanence.mespermanences.MesPermanencesUtils;
import fr.amapj.view.views.permanence.mespermanences.grille.DesinscriptionPopup;
import fr.amapj.view.views.permanence.mespermanences.grille.InscriptionPopup;
import fr.amapj.view.views.permanence.mespermanences.grille.InscriptionPopupRoleDifferent;
import fr.amapj.view.views.permanence.mespermanences.grille.InscriptionPopupToutAutorise;
import java.io.Serializable;

public class GrilleInscriptionPermanence
extends AbstractPeriodePermanenceGrillePart {
    private UnePeriodePermanenceDTO periodePermanenceDTO;

    public GrilleInscriptionPermanence(Long idPeriodePermanence, Long userId) {
        super(idPeriodePermanence, userId);
    }

    @Override
    protected String getHeader() {
        this.periodePermanenceDTO = new MesPermanencesService().loadCompteurPeriodePermanence(this.dto.id, this.userId);
        String cpt = MesPermanencesUtils.getLibCompteur(this.periodePermanenceDTO);
        return cpt;
    }

    @Override
    protected Layout addSpecificButton(PeriodePermanenceDateDTO date) {
        HorizontalLayout hl = new HorizontalLayout();
        hl.setWidth("400px");
        hl.setHeight("45px");
        boolean isInscrit = date.isInscrit(this.userId);
        boolean isComplet = date.isDateComplete();
        boolean isModifiable = MesPermanencesUtils.isDateModifiable(this.periodePermanenceDTO, date);
        if (!isModifiable) {
            return null;
        }
        switch (this.periodePermanenceDTO.regleInscription) {
            case UNE_INSCRIPTION_PAR_DATE: {
                return this.specificButtonInscriptionUniqueParDate(hl, isInscrit, isComplet, date);
            }
            case MULTIPLE_INSCRIPTION_SUR_ROLE_DIFFERENT: 
            case TOUT_AUTORISE: {
                return this.specificButtonInscriptionMultipleParDate(hl, isInscrit, isComplet, date);
            }
        }
        throw new AmapjRuntimeException();
    }

    private Layout specificButtonInscriptionUniqueParDate(HorizontalLayout hl, boolean isInscrit, boolean isComplet, PeriodePermanenceDateDTO date) {
        if (isInscrit) {
            Button b = new Button("Je ne souhaite plus venir \u00e0 cette date.");
            b.addStyleName("suppress-inscrire");
            b.addClickListener((Button.ClickListener & Serializable)e -> this.handleSuppressionInscription(date));
            hl.addComponent((Component)b);
            hl.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
            return hl;
        }
        if (isComplet) {
            return null;
        }
        Button b = new Button("Je m'inscris \u00e0 cette date");
        b.addStyleName("inscrire");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleInscription(date));
        hl.addComponent((Component)b);
        hl.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
        return hl;
    }

    private void handleSuppressionInscription(PeriodePermanenceDateDTO date) {
        DesinscriptionPopup.open(new DesinscriptionPopup(date, this.userId), this);
    }

    private void handleInscription(PeriodePermanenceDateDTO date) {
        InscriptionPopup.open(new InscriptionPopup(date, this.userId, this.dto.id), this);
    }

    private Layout specificButtonInscriptionMultipleParDate(HorizontalLayout hl, boolean isInscrit, boolean isComplet, PeriodePermanenceDateDTO date) {
        if (isInscrit) {
            Button b = new Button("Je change mon choix pour cette date.");
            b.addStyleName("suppress-inscrire");
            b.addClickListener((Button.ClickListener & Serializable)e -> this.handleMultipleInscription(date));
            hl.addComponent((Component)b);
            hl.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
            return hl;
        }
        if (isComplet) {
            return null;
        }
        Button b = new Button("Je m'inscris \u00e0 cette date");
        b.addStyleName("inscrire");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleMultipleInscription(date));
        hl.addComponent((Component)b);
        hl.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
        return hl;
    }

    private void handleMultipleInscription(PeriodePermanenceDateDTO date) {
        if (this.dto.regleInscription == RegleInscriptionPeriodePermanence.TOUT_AUTORISE) {
            InscriptionPopupToutAutorise.open(new InscriptionPopupToutAutorise(date.idPeriodePermanenceDate, this.userId, this.dto.id), this);
        } else {
            InscriptionPopupRoleDifferent.open(new InscriptionPopupRoleDifferent(date.idPeriodePermanenceDate, this.userId, this.dto.id), this);
        }
    }
}

