/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode;

import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.permanence.periode.NaturePeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.model.models.permanence.periode.RegleInscriptionPeriodePermanence;
import fr.amapj.service.services.permanence.periode.FrequencePermanence;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.StringLengthValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import fr.amapj.view.views.permanence.periode.PopupSaisieUtilisateur;
import fr.amapj.view.views.searcher.SearcherList;
import java.io.Serializable;
import java.util.ArrayList;

public class PeriodePermanenceCreationEditorPart
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;
    private ComplexTableBuilder<PeriodePermanenceUtilisateurDTO> builder;
    public static String helpDepassementAutorise = "Permet d'indiquer si un adh\u00e9rent \u00e0 la possibilit\u00e9 de s'inscrire \u00e0 plus de permanences que ce qu'on lui a demand\u00e9.<br/><b>OUI</b> : un adh\u00e9rent peut s'inscrire sur 5 dates diff\u00e9rentes m\u00eame si on lui a demand\u00e9 de s'inscrire sur 3 dates.<br/><b>NON</b> : un adh\u00e9rent ne peut pas d\u00e9passer le nombre d'inscriptions demand\u00e9, il devra s'inscrire exactement le nombre demand\u00e9.<br/>";

    @Override
    protected void configure() {
        this.add(() -> this.drawInfoGenerales(), () -> this.checkInfoGenerales());
        this.add(() -> this.drawDebutFin(), () -> this.checkDebutFin());
        this.add(() -> this.drawDetailDate1());
        this.add(() -> this.drawDetailDate2(), () -> this.checkDetailDate2());
        this.add(() -> this.drawFinInscription());
        this.add(() -> this.drawTransition());
        this.add(() -> this.addDepartChoixUtilisateurs());
        this.add(() -> this.addFieldUtilisateurs(), () -> this.checkUtilisateur());
        this.add(() -> this.addFieldParticipation(), () -> this.checkFieldParticipation());
        this.add(() -> this.addFieldAjuster(), () -> this.checkAjuster());
        this.add(() -> this.addFieldBilan());
    }

    public PeriodePermanenceCreationEditorPart() {
        this.setWidth(80);
        this.popupTitle = "Cr\u00e9ation d'une p\u00e9riode de permanence";
        this.dto = new PeriodePermanenceDTO();
        this.dto.frequencePermanence = FrequencePermanence.UNE_FOIS_PAR_SEMAINE;
        this.dto.nature = NaturePeriodePermanence.INSCRIPTION_LIBRE_AVEC_DATE_LIMITE;
        this.dto.regleInscription = RegleInscriptionPeriodePermanence.UNE_INSCRIPTION_PAR_DATE;
        this.dto.depassementAutorise = ChoixOuiNon.OUI;
        this.setModel(this.dto);
    }

    private void drawInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales de cette p\u00e9riode de permanence");
        StringLengthValidator len_1_100 = new StringLengthValidator(1, 100);
        StringLengthValidator len_1_255 = new StringLengthValidator(1, 255);
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(PeriodePermanence.class, "nom", null);
        NotNullValidator notNull = new NotNullValidator();
        this.addTextField("Nom de la p\u00e9riode de permanence", "nom", len_1_100, uniq);
        this.addTextField("Description de la p\u00e9riode", "description", len_1_255);
        this.addComboEnumField("Nature de la p\u00e9riode", "nature", notNull);
        this.addComboEnumField("Fr\u00e9quence des permanences", "frequencePermanence", notNull);
        this.addIntegerField("Nombre de personnes par permanence", "nbPlaceParDate", new IValidator[0]);
        ComboBox box = this.addComboEnumField("R\u00e9gle d'inscription sur une date", "regleInscription", notNull);
        box.setWidth("600px");
        this.addComboEnumField("D\u00e9passement autoris\u00e9", "depassementAutorise", helpDepassementAutorise, null, new IValidator[]{notNull});
    }

    private String checkInfoGenerales() {
        if (this.dto.nbPlaceParDate < 1) {
            return "Le nombre de personnes par permanence doit \u00eatre sup\u00e9rieur ou \u00e9gal \u00e0 1";
        }
        return null;
    }

    private void drawDebutFin() {
        this.setStepTitle("les dates de permanences");
        NotNullValidator notNull = new NotNullValidator();
        this.addDateField("Date de la premi\u00e8re permanence", "dateDebut", notNull);
        this.addDateField("Date de la derni\u00e8re permanence", "dateFin", notNull);
    }

    private String checkDebutFin() {
        if (this.dto.dateDebut.after(this.dto.dateFin)) {
            return "La date de d\u00e9but doit \u00eatre avant la date de fin ";
        }
        return null;
    }

    private void drawDetailDate1() {
        this.setStepTitle("explication mise au point des dates de permanences");
        String str = "Sur l'\u00e9cran suivant, vous allez pouvoir affiner les dates de permanences en ajoutant , en supprimant ou en barrant certaines dates.<br/>Vous allez pouvoir aussi modifier le nombre de pr\u00e9sents \u00e0 certaines permanences si vous le souhaitez<br/>Si vous n'avez de modifications \u00e0 apporter, il suffira de cliquer sur suivant";
        this.addHtml(str);
    }

    private void drawDetailDate2() {
        if (this.dto.datePerms.size() == 0) {
            new PeriodePermanenceService().fillDatePermanence(this.dto);
        }
        this.setStepTitle("mise au point des dates de permanences");
        CollectionEditor<PeriodePermanenceDateDTO> f1 = this.addCollectionEditorField("Dates", "datePerms", PeriodePermanenceDateDTO.class, new IValidator[0]);
        f1.addColumn("datePerm", "Date permanence", FieldType.DATE, null);
        f1.addColumn("nbPlace", "Nb de personnes", FieldType.QTE, null);
    }

    private String checkDetailDate2() {
        if (this.dto.datePerms.size() == 0) {
            return "Il faut au moins une date de permanence";
        }
        return null;
    }

    protected void drawFinInscription() {
        if (this.dto.nature == NaturePeriodePermanence.INSCRIPTION_LIBRE_FLOTTANT) {
            this.dto.dateFinInscription = null;
            this.setStepTitle("P\u00e9riode de permanence sans date limite d'inscription - D\u00e9lai pour modification des affectations");
            this.addIntegerField("D\u00e9lai en jour pour modification de son affectation avant permanence", "flottantDelai", new IValidator[0]);
            this.addHtml("Votre p\u00e9riode de permanence  est de type SANS date limite d'inscription, c'est \u00e0 dire que l'adh\u00e9rent peut modifier ses dates de permanence m\u00eame apr\u00e8s le d\u00e9but de la p\u00e9riode.<br/>Ce champ vous permet d'indiquer le d\u00e9lai entre la derni\u00e8re modification possible et la date de permanence.<br/>Par exemple, si les permanences sont le samedi et si vous mettez 2 dans ce champ, alors l'adh\u00e9rent pourra alors modifier sa participation \u00e0 cette permanence jusqu'au mercredi soir minuit");
        } else if (this.dto.nature == NaturePeriodePermanence.INSCRIPTION_LIBRE_AVEC_DATE_LIMITE) {
            this.setStepTitle("la date de fin des inscriptions");
            NotNullValidator notNull = new NotNullValidator();
            this.addDateField("Date de fin des inscriptions", "dateFinInscription", notNull);
        } else if (this.dto.nature == NaturePeriodePermanence.INSCRIPTION_NON_LIBRE) {
            this.setStepTitle("P\u00e9riode de permanence avec participation impos\u00e9e");
            this.addHtml("Cliquer sur continuer ...");
        }
    }

    private void drawTransition() {
        this.setStepTitle("affectation des personnes");
        String str = "A ce point, vous avez choisi les dates de votre p\u00e9riode de permanence.<br/>Maintenant, vous allez devoir choisir les personnes qui vont participer \u00e0 ces permanences";
        this.addHtml(str);
    }

    private void addDepartChoixUtilisateurs() {
        this.setStepTitle("choix du groupe de personnes");
        this.addSearcher("P\u00e9riode de cotisation \u00e0 prendre en compte ", "idPeriodeCotisation", SearcherList.PERIODE_COTISATION, null, new IValidator[0]);
        String str = "Le champ pr\u00e9c\u00e9dent permet de pr\u00e9ciser les personnes \u00e0 prendre en compte pour les permanences.</br><br/>Si vous saississez une p\u00e9riode de cotisation, alors uniquement les amapiens ayant cotis\u00e9 sur cette p\u00e9riode et qui sont ACTIF vous seront propos\u00e9s.<br/>Si vous laissez ce champ vide, alors tous les utilisateurs ACTIF  vous seront propos\u00e9s.<br/><br/><br/>A noter : \u00e0 l'\u00e9tape suivante, il vous sera possible de supprimer/ajouter une personne en particulier si vous le souhaitez<br/>";
        this.addHtml(str);
    }

    private void addFieldUtilisateurs() {
        new PeriodePermanenceService().fillUtilisateur(this.dto);
        this.setStepTitle("les personnes de permanence");
        this.builder = new ComplexTableBuilder<PeriodePermanenceUtilisateurDTO>(this.dto.utilisateurs);
        this.builder.setPageLength(14);
        this.builder.addString("Nom", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom", false, 300, e -> e.prenom);
        this.addComplexTable(this.builder);
        Button b = new Button("Ajouter un adh\u00e9rent");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.addAdherent());
        this.form.addComponent((Component)b);
        Button d = new Button("Supprimer un adh\u00e9rent");
        d.addClickListener((Button.ClickListener & Serializable)e -> this.delAdherent());
        this.form.addComponent((Component)d);
    }

    private void addAdherent() {
        PopupSaisieUtilisateur.open(new PopupSaisieUtilisateur(this.dto, new ArrayList<PeriodePermanenceUtilisateurDTO>()), () -> this.endAddAdherent());
    }

    private void endAddAdherent() {
        this.builder.reload(this.dto.utilisateurs);
    }

    private void delAdherent() {
        PeriodePermanenceUtilisateurDTO detail = this.builder.getSelectedLine();
        if (detail != null) {
            this.dto.utilisateurs.remove(detail);
            this.builder.reload(this.dto.utilisateurs);
            Notification.show((String)"Suppression", (String)"Suppression faite", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
        } else {
            Notification.show((String)"Impossible", (String)"Merci de s\u00e9lectionner une ligne pour pouvoir lancer la suppression", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
        }
    }

    private String checkUtilisateur() {
        if (this.dto.utilisateurs.size() == 0) {
            return "Il faut au minimum 1 personne";
        }
        return null;
    }

    private void addFieldParticipation() {
        new PeriodePermanenceService().fillNombreParPersonne(this.dto);
        this.setStepTitle("le nombre de permanences par personne");
        this.addHtml(this.dto.message);
        this.addIntegerField("Nombre de permanence par personne", "nbParPersonne", new IValidator[0]);
        String str = "Sur la page suivante, vous pourrez faire des adjustements, pour indiquer que telle personne doit faire plus ou moins de permanences que les autres<br/>Si vous mettez z\u00e9ro dans ce champ, alors les gens seront libres de s'inscrire ou non, \u00e0 leur convenance.<br/>";
        this.addHtml(str);
    }

    private String checkFieldParticipation() {
        if (this.dto.nbParPersonne < 0) {
            return "Le nombre de permanence par personne doit \u00eatre sup\u00e9rieur ou \u00e9gal \u00e0 0";
        }
        for (PeriodePermanenceUtilisateurDTO detail : this.dto.utilisateurs) {
            detail.nbParticipation = this.dto.nbParPersonne;
        }
        return null;
    }

    private void addFieldAjuster() {
        this.setStepTitle("ajustement");
        this.builder = new ComplexTableBuilder<PeriodePermanenceUtilisateurDTO>(this.dto.utilisateurs);
        this.builder.setPageLength(14);
        this.builder.addString("Nom", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom", false, 300, e -> e.prenom);
        this.builder.addInteger("Nb participation", "nb", true, 100, e -> e.nbParticipation);
        this.addComplexTable(this.builder);
    }

    private String checkAjuster() {
        int i = 0;
        while (i < this.dto.utilisateurs.size()) {
            PeriodePermanenceUtilisateurDTO lig = this.dto.utilisateurs.get(i);
            TextField tf = (TextField)this.builder.getComponent(i, "nb");
            if (tf.getConvertedValue() == null) {
                return "Il faut saisir une valeur pour " + lig.nom + " " + lig.prenom;
            }
            int nb = (Integer)tf.getConvertedValue();
            if (nb < 0) {
                return "La valeur est n\u00e9gative pour " + lig.nom + " " + lig.prenom;
            }
            lig.nbParticipation = nb;
            ++i;
        }
        return null;
    }

    private void addFieldBilan() {
        this.setStepTitle("bilan");
        String bilan = new PeriodePermanenceService().computeBilan(this.dto);
        this.addHtml(bilan);
        this.addHtml("Cliquer sur Sauvegarder pour conserver cette p\u00e9riode de permanence en l'\u00e9tat, ou Annuler pour tout effacer");
    }

    @Override
    protected void performSauvegarder() {
        new PeriodePermanenceService().create(this.dto);
    }
}

