/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode.update;

import fr.amapj.common.DateUtils;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.update.PeriodePermanenceUpdateService;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class PopupAddDateForPeriodePermanence
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;
    private List<PeriodePermanenceDateDTO> existingDatePerms;

    @Override
    protected void configure() {
        this.add(() -> this.saisieDate(), () -> this.checkDates());
    }

    public PopupAddDateForPeriodePermanence(Long id) {
        this.popupTitle = "Ajouter des dates \u00e0 une p\u00e9riode de permanence";
        this.setWidth(80);
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(id);
        this.existingDatePerms = new ArrayList<PeriodePermanenceDateDTO>();
        this.existingDatePerms.addAll(this.dto.datePerms);
        this.dto.datePerms.clear();
        this.setModel(this.dto);
    }

    private void saisieDate() {
        this.setStepTitle("les dates \u00e0 ajouter");
        CollectionEditor<PeriodePermanenceDateDTO> f1 = this.addCollectionEditorField("Dates", "datePerms", PeriodePermanenceDateDTO.class, new IValidator[0]);
        f1.addColumn("datePerm", "Date permanence", FieldType.DATE, null);
        f1.addColumn("nbPlace", "Nb de personnes", FieldType.QTE, null);
    }

    private String checkDates() {
        if (this.dto.datePerms.size() == 0) {
            return "Il faut ajouter au moins une date de permanence";
        }
        for (PeriodePermanenceDateDTO datePerm : this.dto.datePerms) {
            if (!this.isExisting(datePerm)) continue;
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
            return "La date " + df.format(datePerm.datePerm) + " est d\u00e9j\u00e0 existante, vous ne pouvez pas l'ajouter de nouveau";
        }
        return null;
    }

    private boolean isExisting(PeriodePermanenceDateDTO datePerm) {
        for (PeriodePermanenceDateDTO d : this.existingDatePerms) {
            if (!DateUtils.equals(datePerm.datePerm, d.datePerm)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performSauvegarder() {
        new PeriodePermanenceUpdateService().addDates(this.dto);
    }
}

