/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode.update;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.service.services.permanence.periode.update.PeriodePermanenceUpdateService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import fr.amapj.view.views.permanence.periode.PopupSaisieUtilisateur;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PopupAddUtilisateurForPeriodePermanence
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;
    private List<PeriodePermanenceUtilisateurDTO> existingUtilisateurs;
    private ComplexTableBuilder<PeriodePermanenceUtilisateurDTO> builder;

    public PopupAddUtilisateurForPeriodePermanence(Long id) {
        this.popupTitle = "Ajouter des utilisateurs \u00e0 une p\u00e9riode de permanence";
        this.setWidth(80);
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(id);
        this.existingUtilisateurs = new ArrayList<PeriodePermanenceUtilisateurDTO>();
        this.existingUtilisateurs.addAll(this.dto.utilisateurs);
        this.dto.utilisateurs.clear();
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldUtilisateurs(), () -> this.checkUtilisateur());
        this.add(() -> this.addFieldAjuster(), () -> this.checkAjuster());
    }

    private void addFieldUtilisateurs() {
        this.setStepTitle("les personnes \u00e0 ajouter");
        this.builder = new ComplexTableBuilder<PeriodePermanenceUtilisateurDTO>(this.dto.utilisateurs);
        this.builder.setPageLength(14);
        this.builder.addString("Nom", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom", false, 300, e -> e.prenom);
        this.addComplexTable(this.builder);
        Button b = new Button("Ajouter un adh\u00e9rent");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.addAdherent());
        this.form.addComponent((Component)b);
        Button d = new Button("Supprimer un adh\u00e9rent");
        d.addClickListener((Button.ClickListener & Serializable)e -> this.delAdherent());
        this.form.addComponent((Component)d);
    }

    private void addAdherent() {
        PopupSaisieUtilisateur.open(new PopupSaisieUtilisateur(this.dto, this.existingUtilisateurs), () -> this.endAddAdherent());
    }

    private void endAddAdherent() {
        this.builder.reload(this.dto.utilisateurs);
    }

    private void delAdherent() {
        PeriodePermanenceUtilisateurDTO detail = this.builder.getSelectedLine();
        if (detail != null) {
            this.dto.utilisateurs.remove(detail);
            this.builder.reload(this.dto.utilisateurs);
            Notification.show((String)"Suppression", (String)"Suppression faite", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
        } else {
            Notification.show((String)"Impossible", (String)"Merci de s\u00e9lectionner une ligne pour pouvoir lancer la suppression", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
        }
    }

    private String checkUtilisateur() {
        if (this.dto.utilisateurs.size() == 0) {
            return "Il faut au minimum 1 personne";
        }
        return null;
    }

    private void addFieldAjuster() {
        this.setStepTitle("ajustement");
        this.builder = new ComplexTableBuilder<PeriodePermanenceUtilisateurDTO>(this.dto.utilisateurs);
        this.builder.setPageLength(14);
        this.builder.addString("Nom", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom", false, 300, e -> e.prenom);
        this.builder.addInteger("Nb participation", "nb", true, 100, e -> e.nbParticipation);
        this.addComplexTable(this.builder);
    }

    private String checkAjuster() {
        int i = 0;
        while (i < this.dto.utilisateurs.size()) {
            PeriodePermanenceUtilisateurDTO lig = this.dto.utilisateurs.get(i);
            TextField tf = (TextField)this.builder.getComponent(i, "nb");
            if (tf.getConvertedValue() == null) {
                return "Il faut saisir une valeur pour " + lig.nom + " " + lig.prenom;
            }
            int nb = (Integer)tf.getConvertedValue();
            if (nb < 0) {
                return "La valeur est n\u00e9gative pour " + lig.nom + " " + lig.prenom;
            }
            lig.nbParticipation = nb;
            ++i;
        }
        return null;
    }

    @Override
    protected void performSauvegarder() {
        new PeriodePermanenceUpdateService().addUtilisateurs(this.dto);
    }
}

