/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode.update;

import com.vaadin.ui.CheckBox;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.service.services.permanence.periode.update.PeriodePermanenceUpdateService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupDeleteUtilisateurForPeriodePermanence
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;
    private ComplexTableBuilder<PeriodePermanenceUtilisateurDTO> builder;
    private List<PeriodePermanenceUtilisateurDTO> utilisateurToSuppress;

    public PopupDeleteUtilisateurForPeriodePermanence(Long id) {
        this.popupTitle = "Enlever des utilisateurs de cette p\u00e9riode de permanence";
        this.setWidth(80);
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(id);
        this.utilisateurToSuppress = new ArrayList<PeriodePermanenceUtilisateurDTO>();
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.infos());
        this.add(() -> this.addFieldUtilisateurs(), () -> this.checkUtilisateur());
        this.add(() -> this.confirmation());
    }

    private void infos() {
        this.setStepTitle(" les informations g\u00e9n\u00e9rales.");
        this.addHtml("Cet outil va vous permettre d'enlever des utilisateurs de cette p\u00e9riode de permanence, m\u00eame si des utilisateurs sont d\u00e9j\u00e0 inscrits");
    }

    private void addFieldUtilisateurs() {
        this.setStepTitle("choix des les personnes \u00e0 enlever");
        this.addHtml("Veuillez cocher en face des personnes \u00e0 enelever de cette periode de permanence");
        this.builder = new ComplexTableBuilder<PeriodePermanenceUtilisateurDTO>(this.dto.utilisateurs);
        this.builder.setPageLength(14);
        this.builder.addString("Nom", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom", false, 300, e -> e.prenom);
        this.builder.addCheckBox("A enlever", "cb", true, 150, e -> e.toSuppress, null);
        this.addComplexTable(this.builder);
    }

    private String checkUtilisateur() {
        this.utilisateurToSuppress.clear();
        int i = 0;
        while (i < this.dto.utilisateurs.size()) {
            PeriodePermanenceUtilisateurDTO lig = this.dto.utilisateurs.get(i);
            CheckBox cb = (CheckBox)this.builder.getComponent(i, "cb");
            if (((Boolean)cb.getValue()).booleanValue()) {
                this.utilisateurToSuppress.add(lig);
            }
            ++i;
        }
        if (this.utilisateurToSuppress.size() == 0) {
            return "Vous devez supprimer au moins un utilisateur pour pouvoir continuer.";
        }
        return null;
    }

    private void confirmation() {
        String info = new PeriodePermanenceUpdateService().getDeleteUtilisateurInfo(this.utilisateurToSuppress, this.dto.id);
        this.setStepTitle("confirmation avant modification");
        this.addHtml("Vous allez apporter les modifications suivantes sur cette p\u00e9riode de permanence:");
        this.addHtml(info);
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() {
        new PeriodePermanenceUpdateService().performDeleteUtilisateur(this.dto.id, this.utilisateurToSuppress);
    }
}

