/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode.update;

import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceRoleDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.role.UpdateRoleService;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.views.searcher.SearcherList;
import java.util.ArrayList;

public class PopupUpdateAllRole
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;

    public PopupUpdateAllRole(Long id) {
        this.popupTitle = "Positionner les r\u00f4les d'une p\u00e9riode de permanence";
        this.setWidth(80);
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(id);
        this.dto.roles = new ArrayList<PeriodePermanenceRoleDTO>();
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addAide());
        this.add(() -> this.drawRole1(), () -> this.checkRole1());
    }

    private void addAide() {
        this.setStepTitle("explication sur le fonctionnement de cet outil");
        String str = "Cet outil va vous permettre de positionner les r\u00f4les sur une p\u00e9riode de permanence compl\u00e8te.<br/><br/>Vous allez indiquer une liste de r\u00f4les, et l'outil va l'appliquer \u00e0 toutes les dates de la p\u00e9riode.<br/>Si il manque des roles (par exemple une date poss\u00e9de 6 places et vous avez indiqu\u00e9 3 r\u00f4les) , alors l'outil va utiliser 2 fois la liste initiale";
        this.addHtml(str);
    }

    private void drawRole1() {
        this.setStepTitle("la saisie des roles");
        CollectionEditor<PeriodePermanenceRoleDTO> f1 = this.addCollectionEditorField("Role", "roles", PeriodePermanenceRoleDTO.class, new IValidator[0]);
        f1.addSearcherColumn("idRole", "Role", FieldType.SEARCHER, null, SearcherList.PERIODE_PERMANENCE_ROLE, null);
    }

    private String checkRole1() {
        if (this.dto.roles.size() == 0) {
            return "La liste des r\u00f4les doit contenir au moins un \u00e9l\u00e9ment";
        }
        for (PeriodePermanenceRoleDTO role : this.dto.roles) {
            if (role.idRole != null) continue;
            return "Il ne doit pas y avoir de ligne vide";
        }
        return null;
    }

    @Override
    protected void performSauvegarder() {
        new UpdateRoleService().setRole(this.dto);
    }
}

