/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.periode.update;

import com.vaadin.ui.TextField;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.service.services.permanence.periode.update.PeriodePermanenceUpdateService;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupUpdateNbParticipationForPeriodePermanence
extends WizardFormPopup {
    protected PeriodePermanenceDTO dto;
    private ComplexTableBuilder<PeriodePermanenceUtilisateurDTO> builder;
    private List<PeriodePermanenceUtilisateurDTO> existingUtilisateurs;

    public PopupUpdateNbParticipationForPeriodePermanence(Long id) {
        this.popupTitle = "Modifier le nombre de participations des utilisateurs";
        this.setWidth(80);
        this.dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(id);
        this.existingUtilisateurs = new ArrayList<PeriodePermanenceUtilisateurDTO>();
        for (PeriodePermanenceUtilisateurDTO ut : this.dto.utilisateurs) {
            this.existingUtilisateurs.add(ut.clone());
        }
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.infos());
        this.add(() -> this.addFieldAjuster(), () -> this.checkAjuster());
        this.add(() -> this.confirmation());
    }

    private void infos() {
        this.setStepTitle(" les informations g\u00e9n\u00e9rales.");
        this.addHtml("Cet outil va vous permettre de modifier le nombre de participations des utilisateurs, m\u00eame si des adh\u00e9rents sont d\u00e9j\u00e0 inscrits");
    }

    private void addFieldAjuster() {
        this.setStepTitle("nombre de participation");
        this.builder = new ComplexTableBuilder<PeriodePermanenceUtilisateurDTO>(this.dto.utilisateurs);
        this.builder.setPageLength(14);
        this.builder.addString("Nom", false, 300, e -> e.nom);
        this.builder.addString("Pr\u00e9nom", false, 300, e -> e.prenom);
        this.builder.addInteger("Nb participation", "nb", true, 100, e -> e.nbParticipation);
        this.addComplexTable(this.builder);
    }

    private String checkAjuster() {
        int i = 0;
        while (i < this.dto.utilisateurs.size()) {
            PeriodePermanenceUtilisateurDTO lig = this.dto.utilisateurs.get(i);
            TextField tf = (TextField)this.builder.getComponent(i, "nb");
            if (tf.getConvertedValue() == null) {
                return "Il faut saisir une valeur pour " + lig.nom + " " + lig.prenom;
            }
            int nb = (Integer)tf.getConvertedValue();
            if (nb < 0) {
                return "La valeur est n\u00e9gative pour " + lig.nom + " " + lig.prenom;
            }
            lig.nbParticipation = nb;
            ++i;
        }
        return null;
    }

    private void confirmation() {
        String info = new PeriodePermanenceUpdateService().getUpdateNbParticipationInfo(this.dto, this.existingUtilisateurs);
        this.setStepTitle("confirmation avant modification");
        this.addHtml("Vous allez apporter les modifications suivantes sur cette p\u00e9riode de permanence:");
        this.addHtml(info);
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() {
        new PeriodePermanenceUpdateService().performUpdateNbParticipation(this.dto);
    }
}

