/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.permanencerole;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.TextArea;
import fr.amapj.model.models.permanence.periode.PermanenceRole;
import fr.amapj.service.services.permanence.role.PermanenceRoleDTO;
import fr.amapj.service.services.permanence.role.PermanenceRoleService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;

public class PermanenceRoleEditorPart
extends WizardFormPopup {
    private PermanenceRoleDTO dto;
    private boolean create;

    public PermanenceRoleEditorPart(boolean create, PermanenceRoleDTO p) {
        this.create = create;
        this.setWidth(80);
        this.setHeight("90%");
        if (create) {
            this.popupTitle = "Cr\u00e9ation d'un r\u00f4le";
            this.dto = new PermanenceRoleDTO();
            this.dto.defaultRole = false;
        } else {
            this.popupTitle = "Modification d'un r\u00f4le";
            this.dto = p;
        }
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
    }

    @Override
    protected String checkInitialCondition() {
        if (this.dto.defaultRole) {
            return "Vous ne pouvez pas modifier ce role, car c'est le role par d\u00e9faut";
        }
        return null;
    }

    private void addFieldGeneral() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales");
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(PermanenceRole.class, "nom", this.dto.id);
        NotNullValidator notNull = new NotNullValidator();
        this.addTextField("Nom", "nom", uniq, notNull);
        TextArea f = this.addTextAeraField("Description", "description");
        f.setMaxLength(20480);
        f.setHeight(5.0f, Sizeable.Unit.CM);
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new PermanenceRoleService().update(this.dto, this.create);
    }
}

