/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.permanence.permanencerole;

import fr.amapj.service.services.permanence.role.PermanenceRoleDTO;
import fr.amapj.service.services.permanence.role.PermanenceRoleService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.views.permanence.permanencerole.PermanenceRoleEditorPart;
import java.util.List;

public class PermanenceRoleListPart
extends StandardListPart<PermanenceRoleDTO> {
    public PermanenceRoleListPart() {
        super(PermanenceRoleDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des r\u00f4les de permanence";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er un nouveau r\u00f4le", ButtonType.ALWAYS, e -> new PermanenceRoleEditorPart(true, null));
        this.addButton("Modifier", ButtonType.EDIT_MODE, e -> new PermanenceRoleEditorPart(false, (PermanenceRoleDTO)e));
        this.addButton("Supprimer", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom");
    }

    @Override
    protected List<PermanenceRoleDTO> getLines() {
        return new PermanenceRoleService().getAllRoles();
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom"};
    }

    private CorePopup handleSupprimer() {
        PermanenceRoleDTO dto = (PermanenceRoleDTO)this.getSelectedLine();
        if (dto.defaultRole) {
            String str = "Vous ne pouvez pas supprimer ce role, car c'est le role par d\u00e9faut";
            return new MessagePopup("Impossible", CorePopup.ColorStyle.RED, str);
        }
        String text = "Etes vous s\u00fbr de vouloir supprimer le r\u00f4le " + dto.nom + " ?";
        return new SuppressionPopup(text, dto.id, e -> new PermanenceRoleService().delete((Long)e));
    }
}

