/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.producteur.basicform;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.TextArea;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.producteur.ProdUtilisateurDTO;
import fr.amapj.service.services.producteur.ProducteurDTO;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.views.searcher.SearcherList;
import java.text.SimpleDateFormat;

public class ProducteurVoirPart
extends WizardFormPopup {
    private ProducteurDTO producteurDTO;

    public ProducteurVoirPart(ProducteurDTO p) {
        this.setWidth(80);
        this.setHeight("90%");
        this.saveButtonTitle = "OK";
        this.popupTitle = "Visualisation d'un producteur";
        this.producteurDTO = p;
        this.setModel(this.producteurDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addFieldDocuments());
        this.add(() -> this.addFieldUtilisateur());
        this.add(() -> this.addFieldReferents());
    }

    private void addFieldGeneral() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales du producteur");
        this.addTextField("Nom", "nom", new IValidator[0]).setReadOnly(true);
        TextArea f = this.addTextAeraField("Description", "description");
        f.setMaxLength(20480);
        f.setHeight(5.0f, Sizeable.Unit.CM);
        f.setReadOnly(true);
        if (new ParametresService().getParametres().etatGestionStock == EtatModule.ACTIF) {
            this.addComboEnumField("Activer la gestion des limites en quantit\u00e9 pour ce producteur", "gestionStock", new IValidator[0]).setReadOnly(true);
        }
        this.addHtml(ProducteurVoirPart.getInfoProducteur(this.producteurDTO));
    }

    public static String getInfoProducteur(ProducteurDTO producteurDTO) {
        SimpleDateFormat df = FormatUtils.getTimeStd();
        SimpleDateFormat df2 = FormatUtils.getStdDate();
        String str = "Date de cr\u00e9ation : " + df.format(producteurDTO.dateCreation) + "<br/>" + "Date de derni\u00e8re modification : ";
        if (producteurDTO.dateModification != null) {
            str = String.valueOf(str) + df.format(producteurDTO.dateModification);
        }
        str = String.valueOf(str) + "<br/>";
        str = String.valueOf(str) + "Nombre de mod\u00e8les de contrats \u00e0 l'\u00e9tat CREATION ou ACTIF de ce producteur : " + producteurDTO.nbModeleContratActif + "</br>";
        str = producteurDTO.dateDerniereLivraison == null ? String.valueOf(str) + "Aucune date de livraison connue pour ce producteur</br>" : String.valueOf(str) + "Date de la derni\u00e8re livraison : " + df2.format(producteurDTO.dateDerniereLivraison) + "</br>";
        return str;
    }

    private void addFieldDocuments() {
        this.setStepTitle("les documents de ce producteur");
        this.addHtml("<b>La feuille de distribution producteur</b>");
        this.addComboEnumField("La feuille de distribution contient un onglet avec les produits \u00e0 livrer en tableau", "feuilleDistributionGrille", new IValidator[0]).setReadOnly(true);
        this.addComboEnumField("La feuille de distribution contient un onglet avec les produits \u00e0 livrer en liste", "feuilleDistributionListe", new IValidator[0]).setReadOnly(true);
        this.addComboEnumField("La feuille de distribution contient un onglet avec les \u00e9tiquettes des produits ", "feuilleDistributionEtiquette", new IValidator[0]).setReadOnly(true);
        this.addSearcher("Type des \u00e9tiquettes", "idEtiquette", SearcherList.ETIQUETTE, null, new IValidator[0]).setReadOnly(true);
        this.addHtml("<b>Le contrat d'engagement</b>");
        this.addTextField("Identification du producteur sur le contrat d'engagement", "libContrat", new IValidator[0]).setReadOnly(true);
        this.addHtml("<b>L'envoi automatique des feuilles de distribution au producteur</b>");
        this.addIntegerField("D\u00e9lai en jours entre l'envoi de la feuille de distribution par mail et la livraison", "delaiModifContrat", new IValidator[0]).setReadOnly(true);
        String str = "Exemple :<br>Si les livraisons ont lieu le jeudi et si vous mettez 3 dans le champ pr\u00e9c\u00e9dent<br>alors le producteur recevra le mail avec la feuille de distribution le lundi \u00e0 2h00 du matin<br>";
        this.addHtml(str);
    }

    private void addFieldUtilisateur() {
        this.setStepTitle("les noms des producteurs");
        CollectionEditor<ProdUtilisateurDTO> f1 = this.addCollectionEditorField("Liste des producteurs", "utilisateurs", ProdUtilisateurDTO.class, new IValidator[0]);
        f1.addSearcherColumn("idUtilisateur", "Nom du producteur", FieldType.SEARCHER, false, null, SearcherList.UTILISATEUR_ACTIF, null);
        f1.addColumn("etatNotification", "Notification par mail", FieldType.CHECK_BOX, false, true);
        f1.disableAllButtons();
    }

    private void addFieldReferents() {
        this.setStepTitle("les noms des r\u00e9f\u00e9rents");
        CollectionEditor<ProdUtilisateurDTO> f1 = this.addCollectionEditorField("Liste des r\u00e9f\u00e9rents", "referents", ProdUtilisateurDTO.class, new IValidator[0]);
        f1.addSearcherColumn("idUtilisateur", "Nom des r\u00e9f\u00e9rents", FieldType.SEARCHER, false, null, SearcherList.UTILISATEUR_ACTIF, null);
        f1.addColumn("etatNotification", "Notification par mail", FieldType.CHECK_BOX, false, false);
        f1.disableAllButtons();
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
    }
}

