/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.producteur.contrats;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineDTO;
import fr.amapj.service.services.docengagement.signonline.core.CoreDocEngagementSignOnLineService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.io.Serializable;
import java.util.List;

public class PopupSignatureProducteurOneByOne
extends CorePopup {
    private CheckBox cb;
    private List<DocEngagementSignOnLineDTO> dtos;
    private int index;
    private VerticalLayout contentLayout;
    private DocEngagementSignOnLineDTO dto;
    private Button btnSave;
    private Long userId;

    public PopupSignatureProducteurOneByOne(ModeleContratSummaryDTO mc, List<DocEngagementSignOnLineDTO> dtos, Long userId) {
        if (dtos.size() < 1) {
            throw new AmapjRuntimeException();
        }
        this.userId = userId;
        this.dtos = dtos;
        this.popupTitle = "Signature des documents d'engagement pour le contrat " + mc.nom;
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contentLayout = contentLayout;
        this.dto = this.dtos.get(this.index);
        byte[] pdfContent = new CoreDocEngagementSignOnLineService().loadDocEngagementSignePdf(this.dto.idContrat);
        this.addLabel("");
        this.addLabel("Signature du document d'engagement " + (this.index + 1) + " / " + this.dtos.size());
        this.addLabel("");
        contentLayout.addComponent((Component)LinkCreator.createLink("doc-engagement.pdf", "T\u00e9l\u00e9charger le document d'engagement de " + this.dto.nomUtilisateur + " " + this.dto.prenomUtilisateur, pdfContent));
        this.addLabel("");
        this.cb = new CheckBox("J'ai lu et je signe ce document d'engagement");
        this.cb.setValue((Object)false);
        this.cb.addStyleName("signature");
        contentLayout.addComponent((Component)this.cb);
        this.setLibBtnSave();
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
        this.btnSave = this.addDefaultButton("", (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
        this.setLibBtnSave();
    }

    private void setLibBtnSave() {
        if (this.btnSave == null) {
            return;
        }
        this.btnSave.setCaption(this.index == this.dtos.size() - 1 ? "Terminer" : "Continuer ...");
    }

    protected void handleAnnuler() {
        this.close();
    }

    public void handleSauvegarder() {
        if (!((Boolean)this.cb.getValue()).booleanValue()) {
            new MessagePopup("Validation demand\u00e9e", ContentMode.HTML, CorePopup.ColorStyle.RED, "Vous devez signer ce document d'engagement en cliquant sur la case \u00e0 cocher \"J'ai lu et je signe ce document d'engagement\"").open();
            return;
        }
        new CoreDocEngagementSignOnLineService().saveDocEngagementSigneByProducteur(this.dto.idContrat, this.userId);
        if (this.index == this.dtos.size() - 1) {
            this.close();
        } else {
            this.contentLayout.removeAllComponents();
            ++this.index;
            this.createContent(this.contentLayout);
        }
    }

    private void addLabel(String str) {
        Label l = new Label(str);
        this.contentLayout.addComponent((Component)l);
    }
}

