/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.produit;

import com.vaadin.ui.ComboBox;
import fr.amapj.model.models.produitextended.reglesconversion.ProduitLimiteQuantite;
import fr.amapj.service.services.produit.ProduitDTO;
import fr.amapj.service.services.produit.ProduitService;
import fr.amapj.service.services.stockservice.StockUtilService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.fieldlink.FieldLink;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.StringLengthValidator;
import fr.amapj.view.views.searcher.SDProduitOneProducteur;
import java.util.Arrays;

public class ProduitEditorPart
extends WizardFormPopup {
    private ProduitDTO dto;
    private boolean create;
    private boolean gestionStock;

    public ProduitEditorPart(boolean create, Long idProduit, Long idProducteur) {
        this.create = create;
        this.setWidth(80);
        if (create) {
            this.popupTitle = "Cr\u00e9ation d'un produit";
            this.dto = new ProduitDTO();
            this.dto.producteurId = idProducteur;
            this.dto.limiteQuantite = ProduitLimiteQuantite.SUIVI_STANDARD;
        } else {
            this.popupTitle = "Modification d'un produit";
            this.dto = new ProduitService().loadProduit(idProduit);
        }
        this.gestionStock = new StockUtilService().hasProducteurGestionStock(this.dto.producteurId);
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addInfoGenerales());
        if (this.gestionStock) {
            this.add(() -> this.addInfoStock(), () -> this.checkStock());
        }
    }

    protected void addInfoGenerales() {
        StringLengthValidator len_1_255 = new StringLengthValidator(1, 255);
        StringLengthValidator len_1_500 = new StringLengthValidator(1, 500);
        this.addTextField("Nom", "nom", len_1_255);
        this.addTextField("Conditionnement", "conditionnement", len_1_500);
    }

    private void addInfoStock() {
        ComboBox b1 = this.addComboEnumField("La gestion des limites en quantit\u00e9 pour ce produit", "limiteQuantite", new NotNullValidator());
        FieldLink f1 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{ProduitLimiteQuantite.SUIVI_AVEC_REGLE_CALCUL}), b1, true);
        f1.addField(this.addSearcher("Produit \u00e9quivalent", "idProduitEnStock", new SDProduitOneProducteur(this.dto.producteurId), null, f1.getValidator()));
        f1.addField(this.addDoubleField("Coefficient", "coefficient", new IValidator[0]));
        f1.doLink();
    }

    private String checkStock() {
        if (this.dto.limiteQuantite == ProduitLimiteQuantite.NON_SUIVI || this.dto.limiteQuantite == ProduitLimiteQuantite.SUIVI_STANDARD) {
            this.dto.coefficient = 0.0;
            this.dto.idProduitEnStock = null;
            return null;
        }
        if (this.dto.coefficient <= 0.0) {
            return "Le coefficient doit \u00eatre un nombre strictement positif. Exemple : 0.5 ou 1 ou 6 ou ...";
        }
        if (this.dto.idProduitEnStock == null) {
            return "Si vous utilisez une regele de conversion, vous devez indiquer un produit equivalent";
        }
        ProduitDTO prodEquivalent = new ProduitService().loadProduit(this.dto.idProduitEnStock);
        if (prodEquivalent.limiteQuantite == ProduitLimiteQuantite.NON_SUIVI) {
            return "Le produit equivalent n'est pas correct : il doit \u00eatre lui m\u00eame suivi en stock";
        }
        if (prodEquivalent.limiteQuantite == ProduitLimiteQuantite.SUIVI_AVEC_REGLE_CALCUL) {
            return "Le produit equivalent n'est pas correct : il ne peut pas \u00eatre lui m\u00eame bas\u00e9 sur une r\u00e9gle de calcul.";
        }
        return null;
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new ProduitService().update(this.dto, this.create);
    }
}

