/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.produit;

import com.vaadin.ui.Component;
import fr.amapj.service.services.edgenerator.excel.EGListeProduitProducteur;
import fr.amapj.service.services.produit.ProduitDTO;
import fr.amapj.service.services.produit.ProduitService;
import fr.amapj.service.services.web.WebPageDTO;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.views.producteur.ProducteurSelectorPart;
import fr.amapj.view.views.produit.ProduitEditorPart;
import fr.amapj.view.views.webpage.WebPageEditorPart;
import java.util.List;

public class ProduitListPart
extends StandardListPart<ProduitDTO> {
    private ProducteurSelectorPart producteurSelector;

    public ProduitListPart() {
        super(ProduitDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des produits";
    }

    @Override
    protected void addSelectorComponent() {
        this.producteurSelector = new ProducteurSelectorPart(this, true, true);
        this.addComponent((Component)this.producteurSelector.getChoixProducteurComponent());
    }

    @Override
    protected void drawButton() {
        this.addButton("Ajouter un produit", ButtonType.ALWAYS, e -> this.handleAjouter());
        this.addButton("Modifier", ButtonType.EDIT_MODE, e -> new ProduitEditorPart(false, e.id, null));
        this.addButton("Supprimer", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addButton("Description", ButtonType.EDIT_MODE, e -> this.handleDescription((ProduitDTO)e));
        this.addButton("Telecharger", ButtonType.ALWAYS, e -> this.handleTelecharger((ProduitDTO)e));
        this.addSearchField("Rechercher par nom ou conditionnement");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom");
        this.addColumn("conditionnement", "Conditionnement");
    }

    @Override
    protected List<ProduitDTO> getLines() {
        Long idProducteur = this.producteurSelector.getProducteurId();
        if (idProducteur == null) {
            return null;
        }
        return new ProduitService().getAllProduitDTO(idProducteur);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom", "conditionnement"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom", "conditionnement"};
    }

    private ProduitEditorPart handleAjouter() {
        Long idProducteur = this.producteurSelector.getProducteurId();
        return new ProduitEditorPart(true, null, idProducteur);
    }

    protected SuppressionPopup handleSupprimer() {
        ProduitDTO dto = (ProduitDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer le produit " + dto.nom + " , " + dto.conditionnement + " ?";
        return new SuppressionPopup(text, dto.id, e -> new ProduitService().deleteProduit((Long)e));
    }

    private WebPageEditorPart handleDescription(ProduitDTO p) {
        WebPageDTO webPageDto = new ProduitService().loadWebPage(p.id);
        return new WebPageEditorPart(String.valueOf(p.nom) + ", " + p.conditionnement, webPageDto, () -> new ProduitService().saveWebPage(produitDTO.id, webPageDto));
    }

    private TelechargerPopup handleTelecharger(ProduitDTO p) {
        Long idProducteur = this.producteurSelector.getProducteurId();
        TelechargerPopup popup = new TelechargerPopup("Liste des produits et des producteurs", 80);
        popup.addGenerator(new EGListeProduitProducteur(idProducteur, EGListeProduitProducteur.Type.STD));
        popup.addGenerator(new EGListeProduitProducteur(null, EGListeProduitProducteur.Type.STD));
        return popup;
    }
}

