/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.receptioncheque;

import com.vaadin.data.util.converter.Converter;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.paramecran.PEReceptionCheque;
import fr.amapj.service.services.gestioncontratsigne.ContratSigneDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.notification.NotificationHelper;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.engine.tools.BaseUiTools;

public class PopupSaisieAvoir
extends OKCancelPopup {
    private TextField textField;
    private ContratSigneDTO contratSigneDTO;

    public PopupSaisieAvoir(ContratSigneDTO contratSigneDTO) {
        this.contratSigneDTO = contratSigneDTO;
        this.popupTitle = "Saisie de l'avoir";
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        PEReceptionCheque peConf = (PEReceptionCheque)new ParametresService().loadParamEcran(MenuList.RECEPTION_CHEQUES);
        boolean allowNegativeNumber = peConf.saisieAvoirNegatif == ChoixOuiNon.OUI;
        FormLayout f = new FormLayout();
        this.textField = BaseUiTools.createCurrencyField("Montant de l'avoir", allowNegativeNumber);
        this.textField.setConvertedValue((Object)new Integer(this.contratSigneDTO.mntAvoirInitial));
        this.textField.addStyleName("align-center");
        this.textField.addStyleName("big");
        String message = "<h3> Saisie d'un avoir  pour " + this.contratSigneDTO.prenomUtilisateur + " " + this.contratSigneDTO.nomUtilisateur + "</h3>";
        f.addComponent((Component)new Label(message, ContentMode.HTML));
        f.addComponent((Component)this.textField);
        contentLayout.addComponent((Component)f);
    }

    @Override
    protected boolean performSauvegarder() {
        int qte = 0;
        try {
            Integer val = (Integer)this.textField.getConvertedValue();
            if (val != null) {
                qte = val;
            }
        }
        catch (Converter.ConversionException conversionException) {
            NotificationHelper.displayNotification("Erreur de saisie");
            return false;
        }
        new MesContratsService().saveAvoirInitial(this.contratSigneDTO.idContrat, qte);
        return true;
    }
}

