/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.receptioncheque;

import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.TextField;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.paramecran.PEReceptionCheque;
import fr.amapj.service.services.mespaiements.reception.ReceptionChequeDTO;
import fr.amapj.service.services.mespaiements.reception.ReceptionPaiementsService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.formpopup.FormPopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;

public class ReceptionChequeEditorPart
extends FormPopup {
    private SimpleDateFormat df = FormatUtils.getLiteralMonthDate();
    private Long idContrat;
    private String nomUtilisateur;
    private String prenomUtilisateur;
    private List<ReceptionChequeDTO> paiements;
    private PEReceptionCheque peConf;
    private ComplexTableBuilder<ReceptionChequeDTO> builder;
    private Mode mode;
    private Long idModeleContrat;
    private SortMode sortMode;
    private Button tri;

    public ReceptionChequeEditorPart(Long idContrat, String nomUtilisateur, String prenomUtilisateur) {
        this.mode = Mode.CONTRAT;
        this.idContrat = idContrat;
        this.nomUtilisateur = nomUtilisateur;
        this.prenomUtilisateur = prenomUtilisateur;
        this.popupTitle = "R\u00e9ception ch\u00e8ques";
        this.setHeight("90%");
    }

    public ReceptionChequeEditorPart(Long idModeleContrat) {
        this.idModeleContrat = idModeleContrat;
        this.mode = Mode.MODELE_CONTRAT;
        this.popupTitle = "R\u00e9ception des ch\u00e8ques en masse";
        this.setHeight("100%");
    }

    @Override
    protected void addFields() {
        this.peConf = (PEReceptionCheque)new ParametresService().loadParamEcran(MenuList.RECEPTION_CHEQUES);
        this.paiements = this.mode == Mode.CONTRAT ? new ReceptionPaiementsService().getPaiementAReceptionnerContrat(this.idContrat) : new ReceptionPaiementsService().getPaiementAReceptionnerModeleContrat(this.idModeleContrat);
        this.sortMode = SortMode.NOM;
        this.sortPaiement();
        String msg = this.mode == Mode.CONTRAT ? "<h2> R\u00e9ception des ch\u00e8ques de " + this.prenomUtilisateur + " " + this.nomUtilisateur + "</h2>" : "<h2>R\u00e9ception en masse des ch\u00e8ques</h2>";
        this.addHtml(msg);
        if (this.paiements.size() == 0) {
            this.addHtml("Il n'y a pas de ch\u00e8ques \u00e0 r\u00e9ceptionner.");
            this.setWidth(60);
            return;
        }
        this.builder = new ComplexTableBuilder<ReceptionChequeDTO>(this.paiements);
        if (this.mode == Mode.MODELE_CONTRAT) {
            this.builder.addString("Nom", false, 150, e -> e.nomUtilisateur);
            this.builder.addString("Prenom", false, 150, e -> e.prenomUtilisateur);
        }
        this.builder.addString("Date", false, 150, e -> this.df.format(e.datePaiement));
        this.builder.addCurrency("Montant \u20ac", false, 150, e -> e.montant);
        this.builder.addCheckBox("Cocher la case si le ch\u00e8que a \u00e9t\u00e9 re\u00e7u \u00e0 l'AMAP", "cb", true, 150, e -> e.etatPaiement == EtatPaiement.AMAP, null);
        if (this.peConf.saisieCommentaire1 == ChoixOuiNon.OUI) {
            this.builder.addString(this.peConf.libSaisieCommentaire1, "c1", true, 200, e -> e.commentaire1);
        }
        if (this.peConf.saisieCommentaire2 == ChoixOuiNon.OUI) {
            this.builder.addString(this.peConf.libSaisieCommentaire2, "c2", true, 200, e -> e.commentaire2);
        }
        if (this.peConf.saisieCommentaire3 == ChoixOuiNon.OUI) {
            this.builder.addString(this.peConf.libSaisieCommentaire3, "c3", true, 200, e -> e.commentaire3);
        }
        if (this.peConf.saisieCommentaire4 == ChoixOuiNon.OUI) {
            this.builder.addString(this.peConf.libSaisieCommentaire4, "c4", true, 200, e -> e.commentaire4);
        }
        this.addComplexTable(this.builder);
        this.setWidth(60, 100 + this.builder.getTotalWidth());
    }

    private void sortPaiement() {
        if (this.sortMode == SortMode.NOM) {
            CollectionUtils.sort(this.paiements, e -> e.nomUtilisateur, e -> e.prenomUtilisateur, e -> e.datePaiement);
        } else {
            CollectionUtils.sort(this.paiements, e -> e.datePaiement, e -> e.nomUtilisateur, e -> e.prenomUtilisateur);
        }
    }

    @Override
    protected void createButtonBar() {
        if (this.mode == Mode.MODELE_CONTRAT) {
            this.tri = this.addButton("Trier par date", (Button.ClickListener & Serializable)e -> this.handleTri());
        }
        this.addButtonBlank();
        this.addButton("J'ai bien re\u00e7u tous les ch\u00e8ques", (Button.ClickListener & Serializable)e -> this.handleToutSelectionner());
        super.createButtonBar();
    }

    private void handleTri() {
        this.sortMode = this.sortMode.toogle();
        this.tri.setCaption(this.sortMode == SortMode.DATE ? "Trier par nom" : "Trier par date");
        this.writeToModel();
        this.sortPaiement();
        this.builder.reload(this.paiements);
    }

    protected void handleToutSelectionner() {
        int i = 0;
        while (i < this.paiements.size()) {
            CheckBox tf = (CheckBox)this.builder.getComponent(i, "cb");
            tf.setValue((Object)Boolean.TRUE);
            ++i;
        }
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        this.writeToModel();
        new ReceptionPaiementsService().receptionCheque(this.paiements);
    }

    private void writeToModel() {
        int i = 0;
        while (i < this.paiements.size()) {
            TextField tf;
            ReceptionChequeDTO paiement = this.paiements.get(i);
            CheckBox cb = (CheckBox)this.builder.getComponent(i, "cb");
            paiement.etatPaiement = (Boolean)cb.getValue() != false ? EtatPaiement.AMAP : EtatPaiement.A_FOURNIR;
            if (this.peConf.saisieCommentaire1 == ChoixOuiNon.OUI) {
                tf = (TextField)this.builder.getComponent(i, "c1");
                paiement.commentaire1 = (String)tf.getValue();
            }
            if (this.peConf.saisieCommentaire2 == ChoixOuiNon.OUI) {
                tf = (TextField)this.builder.getComponent(i, "c2");
                paiement.commentaire2 = (String)tf.getValue();
            }
            if (this.peConf.saisieCommentaire3 == ChoixOuiNon.OUI) {
                tf = (TextField)this.builder.getComponent(i, "c3");
                paiement.commentaire3 = (String)tf.getValue();
            }
            if (this.peConf.saisieCommentaire4 == ChoixOuiNon.OUI) {
                tf = (TextField)this.builder.getComponent(i, "c4");
                paiement.commentaire4 = (String)tf.getValue();
            }
            ++i;
        }
    }

    public static enum Mode {
        CONTRAT,
        MODELE_CONTRAT;

    }

    public static enum SortMode {
        DATE,
        NOM;


        SortMode toogle() {
            if (this == DATE) {
                return NOM;
            }
            return DATE;
        }
    }
}

