/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.remiseproducteur;

import com.vaadin.ui.Component;
import fr.amapj.service.services.edgenerator.excel.EGRemise;
import fr.amapj.service.services.remiseproducteur.PaiementRemiseDTO;
import fr.amapj.service.services.remiseproducteur.RemiseDTO;
import fr.amapj.service.services.remiseproducteur.RemiseProducteurService;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;

public class RemiseEditorPart
extends WizardFormPopup {
    private RemiseDTO remiseDTO;

    public RemiseEditorPart(RemiseDTO remiseDTO) {
        this.setWidth(80);
        this.popupTitle = "R\u00e9alisation d'une remise";
        this.remiseDTO = remiseDTO;
        this.setModel(remiseDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldAccueil());
        this.add(() -> this.addFieldAffichage());
        this.add(() -> this.addFieldConfirmation());
        this.add(() -> this.addImpression());
    }

    private void addFieldAccueil() {
        this.setStepTitle("saisie de la date de la remise");
        String montant = String.valueOf(new CurrencyTextFieldConverter().convertToString(this.remiseDTO.mnt)) + " \u20ac";
        String text = "Vous allez valider une remise de ch\u00e8ques \u00e0 un producteur<br/>Date de remise pr\u00e9vue au contrat : " + this.remiseDTO.moisRemise + "<br/>" + "Montant total de la remise " + montant + "<br/><br/>" + "Merci de saisir ci dessous la date r\u00e9elle de remise des ch\u00e8ques";
        this.addHtml(text);
        this.addDateField("Date r\u00e9elle de la remise", "dateReelleRemise", new IValidator[0]);
    }

    private void addFieldAffichage() {
        this.setStepTitle("les ch\u00e8ques \u00e0 inclure dans la remise");
        String text = "Voici la liste des ch\u00e8ques \u00e0 inclure dans la remise :<br/>";
        for (PaiementRemiseDTO paiement : this.remiseDTO.paiements) {
            String montant = String.valueOf(new CurrencyTextFieldConverter().convertToString(paiement.montant)) + " \u20ac";
            text = String.valueOf(text) + paiement.nomUtilisateur + " " + paiement.prenomUtilisateur + " - Montant = " + montant;
            text = this.add(text, paiement.commentaire1);
            text = this.add(text, paiement.commentaire2);
            text = this.add(text, paiement.commentaire3);
            text = this.add(text, paiement.commentaire4);
            text = String.valueOf(text) + "<br/>";
        }
        this.addHtml(text);
    }

    private String add(String text, String commentaire) {
        if (commentaire != null) {
            return String.valueOf(text) + " - " + commentaire;
        }
        return text;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        this.setNextButtonAsSave();
        String text = "Confirmez vous avoir tous les ch\u00e8ques ? <br/>";
        this.addHtml(text);
    }

    private void addImpression() {
        Long id = new RemiseProducteurService().performRemise(this.remiseDTO);
        this.setStepTitle("impression");
        this.setAllButtonsAsOK();
        this.addHtml("<b>La remise a bien \u00e9t\u00e9 enregistr\u00e9e.</b><br/>En cliquant sur le lien ci dessous, vous pouvez imprimer un bilan des ch\u00e8ques de cette remise, \u00e0 donner au producteur avec les ch\u00e8ques.");
        this.form.addComponent((Component)LinkCreator.createLink(new EGRemise(id)));
    }

    @Override
    protected void performSauvegarder() {
    }
}

