/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.remiseproducteur;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import fr.amapj.service.services.edgenerator.excel.EGRemise;
import fr.amapj.service.services.remiseproducteur.PaiementRemiseDTO;
import fr.amapj.service.services.remiseproducteur.RemiseDTO;
import fr.amapj.service.services.remiseproducteur.RemiseProducteurService;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.common.contratselector.ContratSelectorPart;
import fr.amapj.view.views.remiseproducteur.RemiseEditorPart;
import java.text.SimpleDateFormat;
import java.util.List;

public class RemiseProducteurListPart
extends StandardListPart<RemiseDTO> {
    private ContratSelectorPart contratSelectorPart;

    public RemiseProducteurListPart() {
        super(RemiseDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des remises de ch\u00e8ques aux producteurs";
    }

    @Override
    protected void drawButton() {
        this.addButton("Faire une remise de ch\u00e8ques", ButtonType.ALWAYS, e -> this.handleAjouter());
        this.addButton("Visualiser une remise", ButtonType.EDIT_MODE, e -> this.handleVoir());
        this.addButton("T\u00e9l\u00e9charger ...", ButtonType.EDIT_MODE, e -> this.handleTelecharger());
        this.addButton("Supprimer une remise", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
    }

    @Override
    protected void addSelectorComponent() {
        this.contratSelectorPart = new ContratSelectorPart(this, true);
        HorizontalLayout toolbar1 = this.contratSelectorPart.getChoixContratComponent();
        this.addComponent((Component)toolbar1);
        this.contratSelectorPart.fillAutomaticValues();
    }

    @Override
    protected void drawTable() {
        this.addColumn("moisRemise", "Date de remise pr\u00e9vue au contrat");
        this.addColumnDateTime("dateCreation", "Date de saisie de la remise");
        this.addColumnDate("dateReelleRemise", "Date r\u00e9elle de la remise");
        this.addColumnCurrency("mnt", "Montant (en \u20ac)").right();
    }

    @Override
    protected List<RemiseDTO> getLines() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        if (idModeleContrat == null) {
            return null;
        }
        return new RemiseProducteurService().getAllRemise(idModeleContrat);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"dateTheoRemise"};
    }

    @Override
    protected String[] getSearchInfos() {
        return null;
    }

    private TelechargerPopup handleTelecharger() {
        RemiseDTO remiseDTO = (RemiseDTO)this.getSelectedLine();
        TelechargerPopup popup = new TelechargerPopup("Remise \u00e0 un producteur");
        popup.addGenerator(new EGRemise(remiseDTO.id));
        return popup;
    }

    private MessagePopup handleVoir() {
        RemiseDTO remiseDTO = (RemiseDTO)this.getSelectedLine();
        String str = this.formatRemise(remiseDTO.id);
        return new MessagePopup("Visualisation d'une remise", ContentMode.HTML, CorePopup.ColorStyle.GREEN, str);
    }

    private CorePopup handleSupprimer() {
        RemiseDTO remiseDTO = (RemiseDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer la remise du " + remiseDTO.moisRemise + " ?";
        return new SuppressionPopup(text, remiseDTO.id, true, e -> new RemiseProducteurService().deleteRemise((Long)e));
    }

    private CorePopup handleAjouter() {
        Long idModeleContrat = this.contratSelectorPart.getModeleContratId();
        RemiseDTO remiseDTO = new RemiseProducteurService().prepareRemise(idModeleContrat);
        if (!remiseDTO.preparationRemiseFailed) {
            return new RemiseEditorPart(remiseDTO);
        }
        return new MessagePopup("Impossible de faire la remise.", ContentMode.HTML, CorePopup.ColorStyle.RED, "Il n'est pas possible de faire la remise \u00e0 cause de :", remiseDTO.messageRemiseFailed);
    }

    private String formatRemise(Long remiseId) {
        RemiseDTO remiseDTO = new RemiseProducteurService().loadRemise(remiseId);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        StringBuffer buf = new StringBuffer();
        buf.append("Remise de ch\u00e8ques du " + remiseDTO.moisRemise + "<br/>");
        buf.append(String.valueOf(remiseDTO.nbCheque) + " ch\u00e8ques dans cette remise<br/>");
        buf.append("Montant total :  " + new CurrencyTextFieldConverter().convertToString(remiseDTO.mnt) + " \u20ac <br/><br/>");
        buf.append("Date de cr\u00e9ation :  " + df.format(remiseDTO.dateCreation) + "<br/>");
        buf.append("Date r\u00e9elle de remise :  " + df.format(remiseDTO.dateReelleRemise) + "<br/><br/>");
        for (PaiementRemiseDTO paiement : remiseDTO.paiements) {
            String text = String.valueOf(paiement.nomUtilisateur) + " " + paiement.prenomUtilisateur + " - " + new CurrencyTextFieldConverter().convertToString(paiement.montant) + " \u20ac ";
            text = this.add(text, paiement.commentaire1);
            text = this.add(text, paiement.commentaire2);
            text = this.add(text, paiement.commentaire3);
            text = this.add(text, paiement.commentaire4);
            text = String.valueOf(text) + "<br/>";
            buf.append(text);
        }
        return buf.toString();
    }

    private String add(String text, String commentaire) {
        if (commentaire != null) {
            return String.valueOf(text) + " - " + commentaire;
        }
        return text;
    }
}

