/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.extendparam.MiseEnFormeGraphique;
import fr.amapj.service.services.gestioncontrat.ExtPModeleContratService;
import fr.amapj.service.services.gestioncontrat.reglesaisie.VerifRegleSaisieModeleContratDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.mescontrats.MonContratDTO;
import fr.amapj.service.services.mescontrats.inscription.InscriptionDTO;
import fr.amapj.service.services.stockservice.verifstock.VerifStockDTO;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.cascadingpopup.CInfo;
import fr.amapj.view.engine.popup.cascadingpopup.CascadingData;
import fr.amapj.view.engine.popup.cascadingpopup.CascadingPopup;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.views.saisiecontrat.abo.joker.SaisieJoker;
import fr.amapj.view.views.saisiecontrat.step1qte.abo.PopupSaisieQteContratPanier;
import fr.amapj.view.views.saisiecontrat.step1qte.std.grid.PopupSaisieQteContrat;
import fr.amapj.view.views.saisiecontrat.step1qte.std.onedatetable.PopupSaisieQteTable;
import fr.amapj.view.views.saisiecontrat.step1qte.std.vueliste.PopupSaisieQteVueListe;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.QtePopupSousType;
import fr.amapj.view.views.saisiecontrat.step2paiement.PopupChoixSaisiePaiement;
import fr.amapj.view.views.saisiecontrat.step2paiement.PopupInfoPaiement;
import fr.amapj.view.views.saisiecontrat.step2paiement.PopupSaisiePaiement;
import fr.amapj.view.views.saisiecontrat.step3signature.PopupSignatureAmapienDirectView;
import java.util.List;

public class SaisieContrat {
    private SaisieContratData data;
    private CascadingPopup cascading;

    public SaisieContrat(SaisieContratData data, PopupListener listener) {
        this.data = data;
        this.cascading = new CascadingPopup(listener, data);
    }

    public void doSaisie() {
        String msg = this.checkInitialCondition();
        if (msg != null) {
            this.cascading.displayError(msg);
            return;
        }
        if (this.data.modeSaisie == ModeSaisie.CHEQUE_SEUL) {
            CInfo info = new CInfo();
            info.popup = this.getPopupPaiement();
            info.actionAfterOnSaveButton = () -> this.data.saveContrat();
            this.cascading.start(info);
            return;
        }
        if (this.data.modeSaisie == ModeSaisie.JOKER) {
            CInfo info = new CInfo();
            info.popup = SaisieJoker.computePopupSaisieJoker(this.data, false);
            info.actionAfterOnSaveButton = () -> this.data.saveContrat();
            this.cascading.start(info);
            return;
        }
        CInfo info = new CInfo();
        info.popup = this.getPopupSaisieQuantite();
        info.actionAfterOnSaveButton = null;
        info.onSuccess = () -> this.endOfSaisieQte();
        this.cascading.start(info);
    }

    private CInfo endOfSaisieQte() {
        if (this.data.modeSaisie == ModeSaisie.QTE_SEUL) {
            return this.handleEndSaisieQteSeul();
        }
        CInfo info = new CInfo();
        info.popup = this.getPopupPaiement();
        info.onSuccess = () -> this.endOfSaisiePaiement();
        info.libSaveButton = this.hasPopupSignatureContrat() ? "Continuer" : "Valider";
        return info;
    }

    private CInfo handleEndSaisieQteSeul() {
        try {
            this.data.saveContrat();
        }
        catch (OnSaveException e) {
            List<String> msgs = e.getAllMessages();
            CInfo info = new CInfo();
            info.popup = new MessagePopup("Impossible de continuer", msgs);
            return info;
        }
        if (this.data.contratDTO.getMontantTotal() == this.data.contratDTO.paiement.getMontantTotalPaiement()) {
            return null;
        }
        CInfo info = new CInfo();
        info.popup = new PopupChoixSaisiePaiement(this.data);
        return info;
    }

    private CInfo endOfSaisiePaiement() {
        CInfo info = new CInfo();
        info.popup = this.getPopupSignatureContrat();
        info.actionAfterOnSaveButton = () -> this.data.saveContrat();
        return info;
    }

    private CorePopup getPopupSaisieQuantite() {
        switch (this.data.inscriptionDTO.popupType) {
            case POPUP_ABO: {
                return new PopupSaisieQteContratPanier(this.data);
            }
            case POPUP_LIBRE: {
                QtePopupSousType sousType = this.computeQtePopupSousType();
                switch (sousType) {
                    case POPUP_DATES_PRODUIT: {
                        return new PopupSaisieQteContrat(this.data);
                    }
                    case POPUP_LISTES_DATES: {
                        return new PopupSaisieQteVueListe(this.data);
                    }
                    case POPUP_PRODUIT: {
                        return new PopupSaisieQteTable(this.data);
                    }
                }
                throw new AmapjRuntimeException();
            }
        }
        throw new AmapjRuntimeException();
    }

    private QtePopupSousType computeQtePopupSousType() {
        if (BaseUiTools.isFirefoxAndroid()) {
            return QtePopupSousType.POPUP_DATES_PRODUIT;
        }
        switch (this.data.miseEnForme.styleSaisieQteContrat) {
            case CHOIX_AUTOMATIQUE: {
                return this.computeChoixAutomatiqueStyleSaisieQteContrat();
            }
            case GRILLE_DATE_PRODUIT: {
                return QtePopupSousType.POPUP_DATES_PRODUIT;
            }
            case LISTE_DATE: {
                return QtePopupSousType.POPUP_LISTES_DATES;
            }
        }
        throw new AmapjRuntimeException();
    }

    private QtePopupSousType computeChoixAutomatiqueStyleSaisieQteContrat() {
        if (this.data.contratDTO.contratLigs.size() == 1) {
            return QtePopupSousType.POPUP_PRODUIT;
        }
        if (this.data.contratDTO.contratColumns.size() * 110 + 110 + 120 <= BaseUiTools.getWidth()) {
            return QtePopupSousType.POPUP_DATES_PRODUIT;
        }
        return QtePopupSousType.POPUP_LISTES_DATES;
    }

    private CorePopup getPopupPaiement() {
        if (this.data.contratDTO.paiement.gestionPaiement == GestionPaiement.GESTION_STANDARD) {
            return new PopupSaisiePaiement(this.data);
        }
        return new PopupInfoPaiement(this.data);
    }

    private CorePopup getPopupSignatureContrat() {
        if (this.hasPopupSignatureContrat()) {
            return new PopupSignatureAmapienDirectView(this.data);
        }
        return null;
    }

    private boolean hasPopupSignatureContrat() {
        return this.data.contratDTO.gestionDocEngagement == GestionDocEngagement.SIGNATURE_EN_LIGNE && (this.data.modeSaisie == ModeSaisie.STANDARD || this.data.modeSaisie == ModeSaisie.FOR_TEST);
    }

    private String checkInitialCondition() {
        if (this.data.inscriptionDTO.errorMessage != null) {
            return this.data.inscriptionDTO.errorMessage;
        }
        switch (this.data.modeSaisie) {
            case STANDARD: {
                return this.checkInitialConditionSaisieStandard();
            }
        }
        return null;
    }

    private String checkInitialConditionSaisieStandard() {
        String msg = new MesContratsService().checkIfAccessAllowed(this.data.contratDTO, this.data.userId);
        return msg;
    }

    public static void saisieContrat(Long idModeleContrat, Long idContrat, Long userId, String messageSpecifique, ModeSaisie modeSaisie, PopupListener listener) {
        MonContratDTO m = new MesContratsService().loadMonContratDTO(idModeleContrat, idContrat, modeSaisie);
        SaisieContratData data = new SaisieContratData(m.contratDTO, m.inscriptionDTO, m.verifStockDTO, m.verifRegleSaisieDTO, userId, messageSpecifique, modeSaisie, listener);
        SaisieContrat saisieContrat = new SaisieContrat(data, listener);
        saisieContrat.doSaisie();
    }

    public static enum ModeSaisie {
        STANDARD,
        JOKER,
        FOR_TEST,
        READ_ONLY,
        QTE_SEUL,
        CHEQUE_SEUL,
        QTE_CHEQUE_REFERENT;

    }

    public static class SaisieContratData
    extends CascadingData {
        public ContratDTO contratDTO;
        public InscriptionDTO inscriptionDTO;
        public VerifStockDTO verifStockDTO;
        public Long userId;
        public String messageSpecifique;
        public ModeSaisie modeSaisie;
        public VerifRegleSaisieModeleContratDTO verifRegleSaisieDTO;
        public MiseEnFormeGraphique miseEnForme;
        public PopupListener listener;

        public SaisieContratData(ContratDTO contratDTO, InscriptionDTO inscriptionDTO, VerifStockDTO verifStockDTO, VerifRegleSaisieModeleContratDTO verifRegleSaisieDTO, Long userId, String messageSpecifique, ModeSaisie modeSaisie, PopupListener listener) {
            this.contratDTO = contratDTO;
            this.inscriptionDTO = inscriptionDTO;
            this.verifStockDTO = verifStockDTO;
            this.verifRegleSaisieDTO = verifRegleSaisieDTO;
            this.userId = userId;
            this.messageSpecifique = messageSpecifique;
            this.modeSaisie = modeSaisie;
            this.miseEnForme = new ExtPModeleContratService().loadMiseEnFormeGraphique(contratDTO.modeleContratId);
            this.listener = listener;
        }

        public void saveContrat() throws OnSaveException {
            if (this.modeSaisie == ModeSaisie.FOR_TEST) {
                return;
            }
            new MesContratsService().saveNewContrat(this.contratDTO, this.userId);
        }
    }
}

