/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.abo;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.contrat.modele.TypJoker;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.views.saisiecontrat.abo.model.AboData;
import fr.amapj.view.views.saisiecontrat.abo.model.AboDataLig;
import fr.amapj.view.views.saisiecontrat.abo.model.AboDataManager;
import fr.amapj.view.views.saisiecontrat.abo.model.AboDataProd;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ContratAbo {
    public ContratDTO contratDTO;
    private int[] qte;

    public ContratAbo(ContratDTO contratDTO, int[] qte) {
        this.contratDTO = contratDTO;
        this.qte = qte;
    }

    public int getQte(int indexProduit) {
        return this.qte[indexProduit];
    }

    public int getNbLivraison(int indexProduit) {
        int nbLivraison = 0;
        int i = 0;
        while (i < this.contratDTO.contratLigs.size()) {
            ContratLigDTO lig = this.contratDTO.contratLigs.get(i);
            if (!this.contratDTO.isExcluded(i, indexProduit) && lig.status != ContratLigDTO.AboLigStatus.FORCED_TO_0 && lig.status != ContratLigDTO.AboLigStatus.JOKER) {
                ++nbLivraison;
            }
            ++i;
        }
        return nbLivraison;
    }

    public boolean isDisponible(int indexProduit) {
        int i = 0;
        while (i < this.contratDTO.contratLigs.size()) {
            ContratLigDTO lig = this.contratDTO.contratLigs.get(i);
            if (!this.contratDTO.isExcluded(i, indexProduit) && lig.status != ContratLigDTO.AboLigStatus.FORCED_TO_0 && lig.status != ContratLigDTO.AboLigStatus.JOKER && !this.contratDTO.cell[i][indexProduit].available) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void updateQte(int indexProduit, int qteSaisie) {
        this.qte[indexProduit] = qteSaisie;
        int[] res = this.computeCol(indexProduit);
        int i = 0;
        while (i < this.contratDTO.contratLigs.size()) {
            this.contratDTO.cell[i][indexProduit].qte = res[i];
            ++i;
        }
    }

    public int getNbJokersUsed() {
        return (int)this.contratDTO.contratLigs.stream().filter(e -> e.status == ContratLigDTO.AboLigStatus.JOKER || e.status == ContratLigDTO.AboLigStatus.REPORT).count();
    }

    public List<DateJokerInfo> getAllDates() {
        ArrayList<DateJokerInfo> res = new ArrayList<DateJokerInfo>();
        for (ContratLigDTO lig : this.contratDTO.contratLigs) {
            DateJokerInfo di = new DateJokerInfo();
            di.date = lig.date;
            di.status = lig.status;
            di.i = lig.i;
            di.isModifiable = lig.isModifiable;
            di.reportDateDestination = lig.reportDateDestination;
            res.add(di);
        }
        return res;
    }

    public void updateJokers(List<DateJokerInfo> dateInfos) throws OnSaveException {
        for (DateJokerInfo dateJokerInfo : dateInfos) {
            String msg = this.checkDateJokerInfo(dateJokerInfo, dateInfos);
            if (msg == null) continue;
            throw new OnSaveException(msg);
        }
        for (DateJokerInfo dateJokerInfo : dateInfos) {
            ContratLigDTO lig = this.contratDTO.contratLigs.get(dateJokerInfo.i);
            lig.status = dateJokerInfo.status;
            lig.reportDateDestination = dateJokerInfo.reportDateDestination;
        }
        String str = this.checkRegleJokerValide();
        if (str != null) {
            throw new AmapjRuntimeException(str);
        }
        this.recomputeAllQte();
    }

    private void recomputeAllQte() {
        int j = 0;
        while (j < this.contratDTO.contratColumns.size()) {
            int qteSaisie = this.qte[j];
            this.updateQte(j, qteSaisie);
            ++j;
        }
    }

    public String getAboInfo() {
        AboData aboData = new AboData();
        for (ContratLigDTO ligDTO : this.contratDTO.contratLigs) {
            if (ligDTO.status == ContratLigDTO.AboLigStatus.NORMAL) continue;
            AboDataLig lig = new AboDataLig();
            lig.date = ligDTO.date;
            lig.status = ligDTO.status;
            lig.reportDateDestination = ligDTO.reportDateDestination;
            aboData.ligs.add(lig);
        }
        for (ContratColDTO contratColDTO : this.contratDTO.contratColumns) {
            int qte = this.getQte(contratColDTO.j);
            if (qte == 0) continue;
            AboDataProd prod = new AboDataProd();
            prod.idProduit = contratColDTO.modeleContratProduitId;
            prod.qte = qte;
            aboData.prods.add(prod);
        }
        return AboDataManager.toString(aboData);
    }

    public String checkRegleJokerValide() {
        long nb;
        SimpleDateFormat df = FormatUtils.getStdDate();
        if (this.contratDTO.typJoker == TypJoker.SANS_JOKER && (nb = this.contratDTO.contratLigs.stream().filter(e -> e.status == ContratLigDTO.AboLigStatus.JOKER || e.status == ContratLigDTO.AboLigStatus.REPORT).count()) != 0L) {
            return "Le contrat est de type SANS JOKER et il y a " + nb + " jokers";
        }
        if (this.contratDTO.typJoker == TypJoker.JOKER_ABSENCE && (nb = this.contratDTO.contratLigs.stream().filter(e -> e.status == ContratLigDTO.AboLigStatus.REPORT).count()) != 0L) {
            return "Le contrat est de type JOKER_ABSENCE et il y a " + nb + " JOKER_REPORT";
        }
        if (this.contratDTO.typJoker == TypJoker.JOKER_REPORT && (nb = this.contratDTO.contratLigs.stream().filter(e -> e.status == ContratLigDTO.AboLigStatus.JOKER).count()) != 0L) {
            return "Le contrat est de type JOKER_REPORT et il y a " + nb + " JOKER_ABSENCE";
        }
        int i = 0;
        while (i < this.contratDTO.contratLigs.size()) {
            ContratLigDTO lig = this.contratDTO.contratLigs.get(i);
            if (lig.status == ContratLigDTO.AboLigStatus.REPORT) {
                if (lig.reportDateDestination == null) {
                    return "Pour la date " + df.format(lig.date) + " un REPORT est renseign\u00e9  mais la date de destination n'est pas renseign\u00e9e";
                }
                ContratLigDTO ligDest = this.contratDTO.findLig(lig.reportDateDestination);
                if (ligDest == null) {
                    return "Pour la date " + df.format(lig.date) + " un REPORT est renseign\u00e9  mais la date de destination n'est pas trouvable.";
                }
                if (ligDest.status != ContratLigDTO.AboLigStatus.NORMAL) {
                    return "Pour la date " + df.format(lig.date) + " un REPORT est renseign\u00e9  vers la date " + df.format(lig.reportDateDestination) + ". Ceci est impossible, car la date destination est d\u00e9j\u00e0 une date report\u00e9e";
                }
                for (ContratColDTO col : this.contratDTO.contratColumns) {
                    if (this.qte[col.j] == 0 || this.contratDTO.isExcluded(lig.i, col.j) || !this.contratDTO.isExcluded(ligDest.i, col.j)) continue;
                    return "Pour la date " + df.format(lig.date) + " un REPORT est renseign\u00e9  vers la date " + df.format(lig.reportDateDestination) + ". Ceci est impossible pour le produit " + col.nomProduit + ", car celui ci n'est pas disponible le " + df.format(lig.reportDateDestination);
                }
            }
            ++i;
        }
        if (this.getNbJokersUsed() < this.contratDTO.jokerNbMin) {
            return "Vous n'avez pas saisi suffisamment de dates jokers. Il faut au minimum " + this.contratDTO.jokerNbMin + " jokers.";
        }
        if (this.getNbJokersUsed() > this.contratDTO.jokerNbMax) {
            return "Vous avez saisi trop de dates jokers. Il faut au maximum " + this.contratDTO.jokerNbMax + " jokers.";
        }
        return null;
    }

    private String checkDateJokerInfo(DateJokerInfo dateJokerInfo, List<DateJokerInfo> dateInfos) {
        SimpleDateFormat df = FormatUtils.getStdDate();
        if (dateJokerInfo.status == ContratLigDTO.AboLigStatus.REPORT) {
            if (dateJokerInfo.reportDateDestination == null) {
                return "Pour la date " + df.format(dateJokerInfo.date) + " un REPORT est renseign\u00e9  mais la date de destination n'est pas renseign\u00e9e";
            }
            if (dateJokerInfo.date.equals(dateJokerInfo.reportDateDestination)) {
                return "Pour la date " + df.format(dateJokerInfo.date) + " un REPORT est renseign\u00e9  mais vers la m\u00eame date.";
            }
            DateJokerInfo ligDest = this.findLig(dateInfos, dateJokerInfo.reportDateDestination);
            if (ligDest == null) {
                return "Pour la date " + df.format(dateJokerInfo.date) + " un REPORT est renseign\u00e9  mais la date de destination n'est pas trouvable.";
            }
            if (ligDest.status != ContratLigDTO.AboLigStatus.NORMAL) {
                return "Pour la date " + df.format(dateJokerInfo.date) + " un REPORT est renseign\u00e9  vers la date " + df.format(dateJokerInfo.reportDateDestination) + ". Ceci est impossible, car la date destination est d\u00e9j\u00e0 une date report\u00e9e";
            }
            for (ContratColDTO col : this.contratDTO.contratColumns) {
                if (this.qte[col.j] == 0 || this.contratDTO.isExcluded(dateJokerInfo.i, col.j) || !this.contratDTO.isExcluded(ligDest.i, col.j)) continue;
                return "Pour la date " + df.format(dateJokerInfo.date) + " un REPORT est renseign\u00e9  vers la date " + df.format(dateJokerInfo.reportDateDestination) + ". Ceci est impossible pour le produit " + col.nomProduit + ", car celui ci n'est pas disponible le " + df.format(dateJokerInfo.reportDateDestination);
            }
        }
        return null;
    }

    private DateJokerInfo findLig(List<DateJokerInfo> dateInfos, Date date) {
        for (DateJokerInfo lig : dateInfos) {
            if (!lig.date.equals(date)) continue;
            return lig;
        }
        return null;
    }

    public String checkValid() {
        String str = this.checkRegleJokerValide();
        if (str != null) {
            return str;
        }
        int j = 0;
        while (j < this.contratDTO.contratColumns.size()) {
            int[] res = this.computeCol(j);
            int i = 0;
            while (i < this.contratDTO.contratLigs.size()) {
                if (res[i] != this.contratDTO.cell[i][j].qte) {
                    return "Il y a une erreur sur le recalcul de la quantit\u00e9 \u00e0 la ligne " + (i + 1) + " colonne " + (j + 1);
                }
                ++i;
            }
            ++j;
        }
        return null;
    }

    private int[] computeCol(int indexProduit) {
        ContratLigDTO lig;
        int[] res = new int[this.contratDTO.contratLigs.size()];
        int qteSaisie = this.qte[indexProduit];
        int i = 0;
        while (i < this.contratDTO.contratLigs.size()) {
            lig = this.contratDTO.contratLigs.get(i);
            res[i] = this.contratDTO.isExcluded(i, indexProduit) || lig.status == ContratLigDTO.AboLigStatus.FORCED_TO_0 || lig.status == ContratLigDTO.AboLigStatus.JOKER || lig.status == ContratLigDTO.AboLigStatus.REPORT ? 0 : qteSaisie;
            ++i;
        }
        i = 0;
        while (i < this.contratDTO.contratLigs.size()) {
            lig = this.contratDTO.contratLigs.get(i);
            if (!this.contratDTO.isExcluded(i, indexProduit) && lig.status == ContratLigDTO.AboLigStatus.REPORT) {
                ContratLigDTO ligDest = this.contratDTO.findLig(lig.reportDateDestination);
                if (ligDest == null || ligDest.status != ContratLigDTO.AboLigStatus.NORMAL) {
                    throw new AmapjRuntimeException("Erreur \u00e0 la ligne " + i + " REPORT incorrect");
                }
                int n = ligDest.i;
                res[n] = res[n] + qteSaisie;
            }
            ++i;
        }
        return res;
    }

    public String dump() {
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < this.contratDTO.contratColumns.size()) {
            buf.append("Prod  " + j + " Qte = " + this.qte[j] + "\n");
            ++j;
        }
        SimpleDateFormat df = FormatUtils.getStdDate();
        int i = 0;
        while (i < this.contratDTO.contratLigs.size()) {
            ContratLigDTO lig = this.contratDTO.contratLigs.get(i);
            String dest = lig.reportDateDestination == null ? "" : df.format(lig.reportDateDestination);
            buf.append("Lig " + i + " Date = " + df.format(lig.date) + "  status = " + (Object)((Object)lig.status) + " Destination Date = " + dest + "\n");
            ++i;
        }
        return buf.toString();
    }

    public static class DateJokerInfo {
        public Date date;
        public ContratLigDTO.AboLigStatus status;
        public boolean isModifiable;
        public int i;
        public Date reportDateDestination;
    }
}

