/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.abo;

import fr.amapj.model.models.contrat.modele.TypJoker;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.views.saisiecontrat.abo.ContratAbo;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContratAboGuesser {
    private static final Logger logger = LogManager.getLogger();
    private int[] qte;
    private ContratDTO dto;

    public ContratAboGuesser(ContratDTO dto) {
        this.dto = dto;
        this.qte = new int[dto.contratColumns.size()];
    }

    public String guessContratAboInfo() {
        this.findQte(this.dto);
        if (this.dto.typJoker == TypJoker.JOKER_ABSENCE || this.dto.typJoker == TypJoker.SANS_JOKER) {
            return this.guessJokerAbsence();
        }
        return this.guessJokerReport();
    }

    private String guessJokerAbsence() {
        int nbFirstLineToZero;
        int i = nbFirstLineToZero = this.countNbFirstLineToZero();
        while (i >= 0) {
            String str = this.guessJokerAbsence(i);
            if (str != null) {
                return str;
            }
            --i;
        }
        logger.debug("GuessJokerAbsence : NOT FOUND");
        return null;
    }

    private int countNbFirstLineToZero() {
        int i = 0;
        while (i < this.dto.contratLigs.size()) {
            if (!this.dto.isEmptyLine(i)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private String guessJokerAbsence(int nbLineToZero) {
        int indexCol = 0;
        while (indexCol < this.qte.length) {
            String str;
            if (this.qte[indexCol] != 0 && (str = this.guessJokerAbsence(nbLineToZero, indexCol)) != null) {
                return str;
            }
            ++indexCol;
        }
        return null;
    }

    private String guessJokerAbsence(int nbLineToZero, int indexRefCol) {
        int i = 0;
        while (i < this.dto.contratLigs.size()) {
            ContratLigDTO lig = this.dto.contratLigs.get(i);
            lig.status = i < nbLineToZero ? ContratLigDTO.AboLigStatus.FORCED_TO_0 : (!this.dto.isExcluded(i, indexRefCol) && this.dto.cell[i][indexRefCol].qte == 0 ? ContratLigDTO.AboLigStatus.JOKER : ContratLigDTO.AboLigStatus.NORMAL);
            ++i;
        }
        ContratAbo abo = new ContratAbo(this.dto, this.qte);
        String str = abo.checkValid();
        if (str != null) {
            return null;
        }
        logger.debug("GuessJokerAbsence : " + abo.dump());
        return abo.getAboInfo();
    }

    private String guessJokerReport() {
        int nbFirstLineToZero;
        int i = nbFirstLineToZero = this.countNbFirstLineToZero();
        while (i >= 0) {
            String str = this.guessJokerReport(i);
            if (str != null) {
                return str;
            }
            --i;
        }
        logger.debug("GuessJokerReport : NOT FOUND");
        return null;
    }

    private String guessJokerReport(int nbLineToZero) {
        int indexCol = 0;
        while (indexCol < this.qte.length) {
            String str;
            if (this.qte[indexCol] != 0 && (str = this.guessJokerReport(nbLineToZero, indexCol)) != null) {
                return str;
            }
            ++indexCol;
        }
        return null;
    }

    private String guessJokerReport(int nbLineToZero, int refCol) {
        ContratLigDTO lig;
        int i = 0;
        while (i < this.dto.contratLigs.size()) {
            lig = this.dto.contratLigs.get(i);
            lig.status = i < nbLineToZero ? ContratLigDTO.AboLigStatus.FORCED_TO_0 : this.findReportStatus(i, refCol);
            ++i;
        }
        i = 0;
        while (i < this.dto.contratLigs.size()) {
            lig = this.dto.contratLigs.get(i);
            if (lig.status == ContratLigDTO.AboLigStatus.REPORT) {
                lig.reportDateDestination = this.findDateDestination(refCol);
            }
            ++i;
        }
        ContratAbo abo = new ContratAbo(this.dto, this.qte);
        String str = abo.checkValid();
        if (str != null) {
            return null;
        }
        logger.debug("GuessJokerReport : " + abo.dump());
        return abo.getAboInfo();
    }

    private ContratLigDTO.AboLigStatus findReportStatus(int i, int refCol) {
        if (!this.dto.isExcluded(i, refCol) && this.dto.cell[i][refCol].qte == 0) {
            return ContratLigDTO.AboLigStatus.REPORT;
        }
        return ContratLigDTO.AboLigStatus.NORMAL;
    }

    private Date findDateDestination(int refCol) {
        int i = 0;
        while (i < this.dto.contratLigs.size()) {
            ContratLigDTO lig = this.dto.contratLigs.get(i);
            if (lig.status == ContratLigDTO.AboLigStatus.NORMAL && this.needQte(lig.i, refCol)) {
                return lig.date;
            }
            ++i;
        }
        return null;
    }

    private boolean needQte(int indexLine, int refCol) {
        int qteNow = this.dto.cell[indexLine][refCol].qte;
        int qteCal = this.computeQte(indexLine, refCol);
        return qteCal < qteNow;
    }

    private int computeQte(int indexLine, int refCol) {
        int q = this.qte[refCol];
        int i = 0;
        while (i < this.dto.contratLigs.size()) {
            ContratLigDTO ligDest;
            ContratLigDTO lig = this.dto.contratLigs.get(i);
            if (lig.reportDateDestination != null && (ligDest = this.dto.findLig(lig.reportDateDestination)) != null && ligDest.i == indexLine) {
                q += this.qte[refCol];
            }
            ++i;
        }
        return q;
    }

    private void findQte(ContratDTO dto) {
        int j = 0;
        while (j < dto.contratColumns.size()) {
            this.qte[j] = this.extractQte(j, dto);
            ++j;
        }
    }

    private int extractQte(int col, ContratDTO dto) {
        int min = 0;
        int i = 0;
        while (i < dto.contratLigs.size()) {
            if (dto.cell[i][col].qte != 0) {
                min = min == 0 ? dto.cell[i][col].qte : Math.min(min, dto.cell[i][col].qte);
            }
            ++i;
        }
        return min;
    }
}

