/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.abo.joker;

import com.vaadin.data.Property;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.abo.ContratAbo;
import fr.amapj.view.views.saisiecontrat.step1qte.abo.ContratAboManager;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.checkonend.CheckOnEndSaisieQte;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class PopupSaisieJokerAbsence
extends OKCancelPopup {
    private ContratAbo abo;
    private List<ComboBox> combos;
    private List<ContratAbo.DateJokerInfo> dateJokerInfos;
    private ContratDTO contratDTO;
    private Label titre;
    private boolean readOnly;
    private SaisieContrat.SaisieContratData data;

    public PopupSaisieJokerAbsence(SaisieContrat.SaisieContratData data, boolean readOnly) {
        this.data = data;
        this.readOnly = readOnly;
        this.abo = data.contratDTO.contratAbo;
        this.contratDTO = data.contratDTO;
        this.combos = new ArrayList<ComboBox>();
        this.dateJokerInfos = this.abo.getAllDates();
        this.popupTitle = "Gestion des jokers de mon contrat " + this.contratDTO.nom;
        if (readOnly) {
            this.hasSaveButton = false;
            this.cancelButtonTitle = "OK";
        } else {
            this.saveButtonTitle = "OK";
        }
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        String msg = this.getTitre(this.abo.getNbJokersUsed());
        this.titre = new Label(msg, ContentMode.HTML);
        contentLayout.addComponent((Component)this.titre);
        int nb = Math.max(this.contratDTO.jokerNbMax, this.getNbDateJoker());
        GridLayout gl = new GridLayout(3, nb);
        gl.setMargin(true);
        gl.setSpacing(true);
        SimpleDateFormat df = FormatUtils.getFullDate();
        int i = 0;
        while (i < nb) {
            ContratAbo.DateJokerInfo dateJoker = this.getDateJoker(i);
            Label l1 = new Label("Joker " + (i + 1));
            l1.setWidth("80px");
            gl.addComponent((Component)l1, 0, i);
            if (this.readOnly) {
                if (dateJoker == null) {
                    gl.addComponent((Component)new Label(""), 1, i);
                    gl.addComponent((Component)new Label(" (Non Utilis\u00e9)"), 2, i);
                } else {
                    gl.addComponent((Component)new Label(df.format(dateJoker.date)), 1, i);
                    gl.addComponent((Component)new Label(""), 2, i);
                }
            } else if (dateJoker == null || dateJoker.isModifiable) {
                ComboBox box = this.createComboBox(dateJoker, df);
                box.setWidth("220px");
                gl.addComponent((Component)box, 1, i);
                this.combos.add(box);
                gl.addComponent((Component)new Label(""), 2, i);
            } else {
                gl.addComponent((Component)new Label(df.format(dateJoker.date)), 1, i);
                gl.addComponent((Component)new Label(" (Non modifiable)"), 2, i);
            }
            ++i;
        }
        contentLayout.addComponent((Component)gl);
    }

    private int getNbDateJoker() {
        return (int)this.dateJokerInfos.stream().filter(e -> e.status == ContratLigDTO.AboLigStatus.JOKER).count();
    }

    private ContratAbo.DateJokerInfo getDateJoker(int i) {
        return this.dateJokerInfos.stream().filter(e -> e.status == ContratLigDTO.AboLigStatus.JOKER).skip(i).findFirst().orElse(null);
    }

    private String getTitre(int nbJokers) {
        return new ContratAboManager().computeJokerMessage(this.contratDTO, nbJokers);
    }

    private ComboBox createComboBox(ContratAbo.DateJokerInfo dateJoker, SimpleDateFormat df) {
        ComboBox comboBox = new ComboBox();
        comboBox.setImmediate(true);
        for (ContratAbo.DateJokerInfo dateJokerInfo : this.dateJokerInfos) {
            if (!dateJokerInfo.isModifiable) continue;
            String caption = df.format(dateJokerInfo.date);
            comboBox.addItem((Object)dateJokerInfo);
            comboBox.setItemCaption((Object)dateJokerInfo, caption);
        }
        if (dateJoker != null) {
            comboBox.select((Object)dateJoker);
        }
        comboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.updateTitre());
        return comboBox;
    }

    private void updateTitre() {
        int nbJokers = (int)this.combos.stream().filter(e -> e.getValue() != null).count();
        this.titre.setValue(this.getTitre(nbJokers));
    }

    @Override
    protected boolean performSauvegarder() throws OnSaveException {
        for (ContratAbo.DateJokerInfo dateJokerInfo : this.dateJokerInfos) {
            if (!dateJokerInfo.isModifiable || dateJokerInfo.status != ContratLigDTO.AboLigStatus.JOKER) continue;
            dateJokerInfo.status = ContratLigDTO.AboLigStatus.NORMAL;
        }
        for (ComboBox comboBox : this.combos) {
            ContratAbo.DateJokerInfo lig = (ContratAbo.DateJokerInfo)comboBox.getValue();
            if (lig == null) continue;
            lig.status = ContratLigDTO.AboLigStatus.JOKER;
        }
        this.abo.updateJokers(this.dateJokerInfos);
        if (!new CheckOnEndSaisieQte().check(this.data)) {
            return false;
        }
        this.data.validate();
        return true;
    }
}

