/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.abo.joker;

import com.vaadin.data.Property;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelPopup;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.abo.ContratAbo;
import fr.amapj.view.views.saisiecontrat.step1qte.abo.ContratAboManager;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.checkonend.CheckOnEndSaisieQte;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class PopupSaisieJokerReport
extends OKCancelPopup {
    private ContratAbo abo;
    private List<Ligne> lignes;
    private List<ContratAbo.DateJokerInfo> dateJokerInfos;
    private ContratDTO contratDTO;
    private Label titre;
    private boolean readOnly;
    private SaisieContrat.SaisieContratData data;

    public PopupSaisieJokerReport(SaisieContrat.SaisieContratData data, boolean readOnly) {
        this.data = data;
        this.readOnly = readOnly;
        this.abo = data.contratDTO.contratAbo;
        this.contratDTO = data.contratDTO;
        this.lignes = new ArrayList<Ligne>();
        this.dateJokerInfos = this.abo.getAllDates();
        this.popupTitle = "Gestion des jokers de mon contrat " + this.contratDTO.nom;
        this.setWidth(60);
        if (readOnly) {
            this.hasSaveButton = false;
            this.cancelButtonTitle = "OK";
        } else {
            this.saveButtonTitle = "OK";
        }
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        String msg = this.getTitre(this.abo.getNbJokersUsed());
        this.titre = new Label(msg, ContentMode.HTML);
        contentLayout.addComponent((Component)this.titre);
        int nb = Math.max(this.contratDTO.jokerNbMax, this.getNbDateJokerInitial());
        GridLayout gl = new GridLayout(4, nb);
        gl.setMargin(true);
        gl.setSpacing(true);
        if (this.readOnly) {
            this.drawReadOnly(gl, nb);
        } else {
            this.drawEditable(gl, nb);
        }
        contentLayout.addComponent((Component)gl);
    }

    private void drawEditable(GridLayout gl, int nb) {
        int i = 0;
        while (i < nb) {
            ContratAbo.DateJokerInfo dateJoker = this.getDateJoker(i);
            Label l1 = new Label("Joker " + (i + 1));
            l1.setWidth("80px");
            gl.addComponent((Component)l1, 0, i);
            Ligne l = new Ligne();
            this.addCol1(l, gl, dateJoker, i);
            gl.addComponent((Component)new Label("Report\u00e9 au "), 2, i);
            ContratAbo.DateJokerInfo dateJokerDestination = this.findDestination(dateJoker);
            this.addCol2(l, gl, dateJokerDestination, i);
            this.lignes.add(l);
            ++i;
        }
    }

    private ContratAbo.DateJokerInfo findDestination(ContratAbo.DateJokerInfo dateJoker) {
        if (dateJoker == null || dateJoker.reportDateDestination == null) {
            return null;
        }
        for (ContratAbo.DateJokerInfo dateJokerInfo : this.dateJokerInfos) {
            if (!dateJokerInfo.date.equals(dateJoker.reportDateDestination)) continue;
            return dateJokerInfo;
        }
        throw new AmapjRuntimeException();
    }

    private void addCol1(Ligne l, GridLayout gl, ContratAbo.DateJokerInfo dateJoker, int index) {
        if (dateJoker != null && !dateJoker.isModifiable) {
            SimpleDateFormat df = FormatUtils.getFullDate();
            gl.addComponent((Component)new Label(df.format(dateJoker.date)), 1, index);
            l.initialCol1 = dateJoker;
        } else {
            ComboBox box = this.createComboBox(dateJoker);
            box.setWidth("220px");
            gl.addComponent((Component)box, 1, index);
            l.box1 = box;
        }
    }

    private void addCol2(Ligne l, GridLayout gl, ContratAbo.DateJokerInfo dateJoker, int index) {
        if (dateJoker != null && !dateJoker.isModifiable) {
            SimpleDateFormat df = FormatUtils.getFullDate();
            gl.addComponent((Component)new Label(df.format(dateJoker.date)), 3, index);
            l.initialCol2 = dateJoker;
        } else {
            ComboBox box = this.createComboBox(dateJoker);
            box.setWidth("220px");
            gl.addComponent((Component)box, 3, index);
            l.box2 = box;
        }
    }

    private void drawReadOnly(GridLayout gl, int nb) {
        SimpleDateFormat df = FormatUtils.getFullDate();
        int i = 0;
        while (i < nb) {
            ContratAbo.DateJokerInfo dateJoker = this.getDateJoker(i);
            Label l1 = new Label("Joker " + (i + 1));
            l1.setWidth("80px");
            gl.addComponent((Component)l1, 0, i);
            if (dateJoker == null) {
                gl.addComponent((Component)new Label(" Non Utilis\u00e9"), 1, i);
            } else {
                gl.addComponent((Component)new Label(df.format(dateJoker.date)), 1, i);
                gl.addComponent((Component)new Label("Report\u00e9 au "), 2, i);
                gl.addComponent((Component)new Label(df.format(dateJoker.reportDateDestination)), 3, i);
            }
            ++i;
        }
    }

    private int getNbDateJokerInitial() {
        return (int)this.dateJokerInfos.stream().filter(e -> e.status == ContratLigDTO.AboLigStatus.REPORT).count();
    }

    private ContratAbo.DateJokerInfo getDateJoker(int i) {
        return this.dateJokerInfos.stream().filter(e -> e.status == ContratLigDTO.AboLigStatus.REPORT).skip(i).findFirst().orElse(null);
    }

    private String getTitre(int nbJokers) {
        return new ContratAboManager().computeJokerMessage(this.contratDTO, nbJokers);
    }

    private ComboBox createComboBox(ContratAbo.DateJokerInfo dateJoker) {
        SimpleDateFormat df = FormatUtils.getFullDate();
        ComboBox comboBox = new ComboBox();
        comboBox.setImmediate(true);
        for (ContratAbo.DateJokerInfo dateJokerInfo : this.dateJokerInfos) {
            if (!dateJokerInfo.isModifiable) continue;
            String caption = df.format(dateJokerInfo.date);
            comboBox.addItem((Object)dateJokerInfo);
            comboBox.setItemCaption((Object)dateJokerInfo, caption);
        }
        if (dateJoker != null) {
            comboBox.select((Object)dateJoker);
        }
        comboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.updateTitre());
        return comboBox;
    }

    private void updateTitre() {
        int nbJokers = (int)this.lignes.stream().filter(e -> this.isComplete((Ligne)e)).count();
        this.titre.setValue(this.getTitre(nbJokers));
    }

    private boolean isComplete(Ligne l) {
        return l.getVal1() != null && l.getVal2() != null;
    }

    @Override
    protected boolean performSauvegarder() throws OnSaveException {
        int i = 0;
        while (i < this.lignes.size()) {
            Ligne l = this.lignes.get(i);
            if (l.getVal1() == null && l.getVal2() != null || l.getVal1() != null && l.getVal2() == null) {
                throw new OnSaveException("La ligne " + (i + 1) + " est incorrecte");
            }
            ++i;
        }
        for (ContratAbo.DateJokerInfo dateJokerInfo : this.dateJokerInfos) {
            if (dateJokerInfo.status != ContratLigDTO.AboLigStatus.REPORT) continue;
            dateJokerInfo.status = ContratLigDTO.AboLigStatus.NORMAL;
            dateJokerInfo.reportDateDestination = null;
        }
        for (Ligne l : this.lignes) {
            ContratAbo.DateJokerInfo dateJokerInfo = l.getVal1();
            if (dateJokerInfo == null) continue;
            dateJokerInfo.status = ContratLigDTO.AboLigStatus.REPORT;
            dateJokerInfo.reportDateDestination = l.getVal2().date;
        }
        this.abo.updateJokers(this.dateJokerInfos);
        if (!new CheckOnEndSaisieQte().check(this.data)) {
            return false;
        }
        this.data.validate();
        return true;
    }

    public static class Ligne {
        public ContratAbo.DateJokerInfo initialCol1;
        public ComboBox box1;
        public ContratAbo.DateJokerInfo initialCol2;
        public ComboBox box2;

        public ContratAbo.DateJokerInfo getVal1() {
            if (this.box1 != null) {
                return (ContratAbo.DateJokerInfo)this.box1.getValue();
            }
            return this.initialCol1;
        }

        public ContratAbo.DateJokerInfo getVal2() {
            if (this.box2 != null) {
                return (ContratAbo.DateJokerInfo)this.box2.getValue();
            }
            return this.initialCol2;
        }
    }
}

