/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step1qte.abo;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.grid.integergrid.IntegerGridCell;
import fr.amapj.view.engine.grid.integergrid.IntegerGridLine;
import fr.amapj.view.engine.grid.integergrid.PopupIntegerGrid;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.abo.ContratAbo;
import fr.amapj.view.views.saisiecontrat.abo.joker.SaisieJoker;
import fr.amapj.view.views.saisiecontrat.step1qte.abo.ContratAboManager;
import fr.amapj.view.views.saisiecontrat.step1qte.abo.PopupDetailDate;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.ProduitHelpSupplier;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.checkonend.CheckOnEndSaisieQte;
import java.io.Serializable;
import java.util.List;

public class PopupSaisieQteContratPanier
extends PopupIntegerGrid {
    private ContratDTO contratDTO;
    private SaisieContrat.SaisieContratData data;
    private int largeurColonne = 500;
    private ContratAbo abo;

    public PopupSaisieQteContratPanier(SaisieContrat.SaisieContratData data) {
        this.data = data;
        this.contratDTO = data.contratDTO;
        this.abo = data.contratDTO.contratAbo;
        this.popupTitle = "Mon contrat " + this.contratDTO.nom;
        this.param.readOnly = data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY;
        this.param.messageSpecifique = PopupSaisieQteContratPanier.s(data.messageSpecifique);
        this.param.libButtonSave = "Continuer ...";
    }

    @Override
    public void loadParam() {
        if (this.contratDTO.jokerNbMax > 0) {
            this.param.messageSpecifiqueBottom = this.computeJokerMessage();
        }
        this.param.nbLig = this.contratDTO.contratColumns.size();
        this.param.nbCol = 1;
        this.computeCells();
        this.param.buttonCopyFirstLine = false;
        this.param.largeurCol = 110;
        GridHeaderLine line1 = new GridHeaderLine();
        line1.addCell("Produit");
        line1.addCell("Qte");
        this.param.headerLines.add(line1);
        this.param.leftPartLineLargeur = this.largeurColonne;
        this.param.leftPartLineStyle = "description-panier";
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            IntegerGridLine line = new IntegerGridLine();
            line.isVisible = true;
            line.leftPart = this.getText(col);
            line.leftPartHelpSupplier = new ProduitHelpSupplier(col);
            this.param.lines.add(line);
        }
    }

    private void fillTableauPrix() {
        int j = 0;
        while (j < this.contratDTO.contratColumns.size()) {
            ContratColDTO col = this.contratDTO.contratColumns.get(j);
            this.param.cell[j][0].prix = col.prix * this.abo.getNbLivraison(j);
            ++j;
        }
    }

    private void computeCells() {
        this.param.cell = new IntegerGridCell[this.contratDTO.contratColumns.size()][1];
        int j = 0;
        while (j < this.contratDTO.contratColumns.size()) {
            IntegerGridCell c = new IntegerGridCell();
            int nbLivraison = this.abo.getNbLivraison(j);
            if (nbLivraison == 0) {
                c.isStaticText = true;
                c.staticText = "XXXXXX";
            } else if (!this.abo.isDisponible(j) && this.abo.getQte(j) == 0) {
                c.isStaticText = true;
                c.staticText = "Non disponible";
            } else {
                c.isStaticText = false;
                c.qte = this.abo.getQte(j);
                c.prix = 0;
            }
            this.param.cell[j][0] = c;
            ++j;
        }
        this.fillTableauPrix();
    }

    private String getText(ContratColDTO col) {
        String str = String.valueOf(this.getLine1(col)) + "<br/>";
        str = String.valueOf(str) + "Prix unitaire : " + new CurrencyTextFieldConverter().convertToString(col.prix) + " \u20ac<br/>";
        int nbLivraison = this.abo.getNbLivraison(col.j);
        str = nbLivraison == 0 ? String.valueOf(str) + "Produit non disponible" : String.valueOf(str) + "<b>" + nbLivraison + " livraisons , prix total de " + new CurrencyTextFieldConverter().convertToString(nbLivraison * col.prix) + " \u20ac</b>";
        return str;
    }

    private String getLine1(ContratColDTO col) {
        return "Abonnement pour 1 " + col.nomProduit + "," + col.condtionnementProduit;
    }

    @Override
    protected void handleContinuer() {
        this.data.validate();
        this.close();
    }

    @Override
    public boolean performSauvegarder() {
        this.updateFromSaisie();
        String msg = this.abo.checkRegleJokerValide();
        if (msg != null) {
            new MessagePopup("Impossible de continuer", ContentMode.HTML, CorePopup.ColorStyle.RED, msg).open();
            return false;
        }
        if (!new CheckOnEndSaisieQte().check(this.data)) {
            return false;
        }
        this.data.validate();
        return true;
    }

    private void updateFromSaisie() {
        int j = 0;
        while (j < this.contratDTO.contratColumns.size()) {
            int qteSaisie = this.param.cell[j][0].qte;
            this.abo.updateQte(j, qteSaisie);
            ++j;
        }
    }

    @Override
    public int getLineHeight(boolean readOnly) {
        int nbLineMax = this.getNbLineMax();
        return (nbLineMax + 1 + 1) * 16 + 10 + 10;
    }

    private int getNbLineMax() {
        int nbLine = 1;
        GridSizeCalculator cal = new GridSizeCalculator();
        for (ContratColDTO col : this.contratDTO.contratColumns) {
            String cell = this.getLine1(col);
            nbLine = Math.max(nbLine, cal.getHeight(cell, this.largeurColonne - 22, "Arial", 16));
        }
        return nbLine;
    }

    @Override
    public int getHeaderHeight() {
        return BaseUiTools.isCompactMode() ? 185 : 284;
    }

    @Override
    protected void createButtonBar() {
        this.addButton("D\u00e9tail des dates de livraison", (Button.ClickListener & Serializable)e -> this.handleDetailDate());
        if (this.contratDTO.jokerNbMax > 0) {
            String caption = this.data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY ? "Voir mes jokers" : "Choisir mes jokers";
            this.addButton(caption, (Button.ClickListener & Serializable)e -> this.handleJoker());
        }
        super.createButtonBar();
    }

    private void handleDetailDate() {
        this.updateFromSaisie();
        new PopupDetailDate(this.contratDTO).open();
    }

    private void handleJoker() {
        SaisieJoker.doSaisieJoker(this.data, this.data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY, () -> this.onJokerClose());
    }

    public void onJokerClose() {
        this.updateLabelMessageSpecifiqueBottom(this.computeJokerMessage());
        List<ContratColDTO> contratColumns = this.contratDTO.contratColumns;
        int i = 0;
        while (i < contratColumns.size()) {
            ContratColDTO col = contratColumns.get(i);
            this.updateFirstCol(i, this.getText(col));
            ++i;
        }
        this.fillTableauPrix();
        this.updatePrixTotal();
    }

    private String computeJokerMessage() {
        return new ContratAboManager().computeJokerMessage(this.contratDTO, this.abo.getNbJokersUsed());
    }
}

