/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.saisiecontrat.step1qte.std.onedatetable;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.view.engine.grid.integergrid.IntegerGridCell;
import fr.amapj.view.engine.grid.integertable.PopupIntegerTable;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.saisiecontrat.step1qte.std.grid.PopupSaisieQteContrat;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.QteTableUtils;
import fr.amapj.view.views.saisiecontrat.step1qte.utils.checkonend.CheckOnEndSaisieQte;
import java.text.SimpleDateFormat;

public class PopupSaisieQteTable
extends PopupIntegerTable {
    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private ContratDTO contratDTO;
    private SaisieContrat.SaisieContratData data;
    private int indexLig;

    public PopupSaisieQteTable(SaisieContrat.SaisieContratData data) {
        this.data = data;
        this.contratDTO = data.contratDTO;
        this.popupTitle = "Date de livraison : " + FormatUtils.getStdDate().format(this.contratDTO.contratLigs.get((int)0).date) + " - " + this.contratDTO.nom;
        this.param.readOnly = data.modeSaisie == SaisieContrat.ModeSaisie.READ_ONLY;
        this.param.messageSpecifique = PopupSaisieQteTable.s(data.messageSpecifique);
        this.param.libButtonSave = "Continuer ...";
    }

    @Override
    public void loadParam() {
        if (this.contratDTO.contratLigs.size() != 1) {
            throw new AmapjRuntimeException();
        }
        this.indexLig = 0;
        if (!this.param.readOnly && !this.contratDTO.contratLigs.get((int)this.indexLig).isModifiable) {
            throw new AmapjRuntimeException();
        }
        this.param.nbCell = this.contratDTO.contratColumns.size();
        IntegerGridCell[][] cs = this.contratDTO.extractCells();
        this.param.cell = new QteTableUtils().convertOneLineOfCells(this.contratDTO, cs, this.indexLig);
        this.param.allowedEmpty = false;
        this.param.libPrixTotal = "Montant pour la date du " + FormatUtils.getStdDate().format(this.contratDTO.contratLigs.get((int)this.indexLig).date);
        this.param.switchButtonAction = () -> this.handleSwitchButton();
    }

    private void handleSwitchButton() {
        int j = 0;
        while (j < this.param.nbCell) {
            this.contratDTO.cell[this.indexLig][j].qte = this.param.cell[j].qte;
            ++j;
        }
        PopupSaisieQteContrat popup = new PopupSaisieQteContrat(this.data);
        this.data.insertPopup(popup);
    }

    @Override
    protected void handleContinuer() {
        this.data.validate();
        this.close();
    }

    @Override
    public boolean performSauvegarder() {
        int j = 0;
        while (j < this.param.nbCell) {
            this.contratDTO.cell[this.indexLig][j].qte = this.param.cell[j].qte;
            ++j;
        }
        if (!new CheckOnEndSaisieQte().check(this.data)) {
            return false;
        }
        this.data.validate();
        return true;
    }
}

